/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.DatasourceConnectionProvider;
import org.nuxeo.runtime.api.ConnectionHelper;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoConnectionProvider
implements ConnectionProvider {
    protected DatasourceConnectionProvider dscp;
    protected String dataSourceName;
    protected boolean began;

    public void configure(Properties props) throws HibernateException {
        this.dscp = new DatasourceConnectionProvider();
        this.dscp.configure(props);
        this.dataSourceName = props.getProperty("hibernate.connection.datasource");
    }

    public Connection getConnection() throws SQLException {
        Connection connection = ConnectionHelper.getConnection((String)this.dataSourceName);
        if (connection == null) {
            connection = this.dscp.getConnection();
        }
        this.begin(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection connection) throws SQLException {
        try {
            this.commit(connection);
        }
        finally {
            connection.close();
        }
    }

    private void begin(Connection connection) throws SQLException {
        this.began = false;
        if (!connection.getAutoCommit()) {
            return;
        }
        try {
            Transaction transaction = TransactionHelper.lookupTransactionManager().getTransaction();
            if (transaction != null && transaction.getStatus() == 0) {
                connection.setAutoCommit(false);
                this.began = true;
            }
        }
        catch (NamingException e) {
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    private void commit(Connection connection) throws SQLException {
        if (this.began) {
            this.began = false;
            connection.commit();
        }
    }

    public void close() throws HibernateException {
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

