/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharList;
import org.apache.commons.collections.primitives.adapters.AbstractCharCollectionCollection;
import org.apache.commons.collections.primitives.adapters.CharListIteratorListIterator;
import org.apache.commons.collections.primitives.adapters.CharListList;
import org.apache.commons.collections.primitives.adapters.CollectionCharCollection;

abstract class AbstractCharListList
extends AbstractCharCollectionCollection
implements List<Character> {
    AbstractCharListList() {
    }

    @Nonnull
    protected abstract CharList getCharList();

    @Override
    @Nonnull
    protected final CharCollection getCharCollection() {
        return this.getCharList();
    }

    @Override
    public void add(int n, @Nonnull Character c) {
        this.getCharList().add(n, c.charValue());
    }

    @Override
    public boolean addAll(int n, Collection<? extends Character> collection) {
        return this.getCharList().addAll(n, CollectionCharCollection.wrap(collection));
    }

    @Override
    @Nonnull
    public Character get(int n) {
        return Character.valueOf(this.getCharList().get(n));
    }

    @Override
    public int indexOf(Object object) {
        return this.getCharList().indexOf(((Character)object).charValue());
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getCharList().lastIndexOf(((Character)object).charValue());
    }

    @Override
    public ListIterator<Character> listIterator() {
        return CharListIteratorListIterator.wrap(this.getCharList().listIterator());
    }

    @Override
    public ListIterator<Character> listIterator(int n) {
        return CharListIteratorListIterator.wrap(this.getCharList().listIterator(n));
    }

    @Override
    @Nonnull
    public Character remove(int n) {
        return Character.valueOf(this.getCharList().removeElementAt(n));
    }

    @Override
    @Nonnull
    public Character set(int n, Character c) {
        return Character.valueOf(this.getCharList().set(n, c.charValue()));
    }

    @Override
    public List<Character> subList(int n, int n2) {
        return CharListList.wrap(this.getCharList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator<Character> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            Character c = iterator.next();
            Object e = iterator2.next();
            if (!(null == c ? null != e : !((Object)c).equals(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getCharList()).hashCode();
    }
}

