/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.InverseReference;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;

@XObject(value="directory")
public class SQLDirectoryDescriptor {
    private static final Log log = LogFactory.getLog(SQLDirectoryDescriptor.class);
    public static final int CACHE_TIMEOUT_DEFAULT = 0;
    public static final int CACHE_MAX_SIZE_DEFAULT = 0;
    public static final int QUERY_SIZE_LIMIT_DEFAULT = 0;
    public static final boolean AUTO_INCREMENT_ID_FIELD_DEFAULT = false;
    public static final boolean READ_ONY_DEFAULT = false;
    protected static final char DEFAULT_CHARACTER_SEPARATOR = ',';
    private static final String[] SCRIPT_POLICIES = new String[]{"never", "on_missing_columns", "always"};
    private static final String DEFAULT_POLICY = "never";
    @XNode(value="@name")
    public String name;
    @XNode(value="schema")
    public String schemaName;
    @XNode(value="parentDirectory")
    public String parentDirectory;
    @XNode(value="dataSource")
    public String dataSourceName;
    @XNode(value="dbDriver")
    public String dbDriver;
    @XNode(value="dbUrl")
    public String dbUrl;
    @XNode(value="dbUser")
    public String dbUser;
    @XNode(value="dbPassword")
    public String dbPassword;
    @XNode(value="table")
    public String tableName;
    @XNodeList(value="init-dependencies/dependency", type=ArrayList.class, componentType=String.class)
    public List<String> initDependencies;
    @XNode(value="idField")
    public String idField;
    @XNode(value="dataFile")
    public String dataFileName;
    @XNode(value="dataFileCharacterSeparator", trim=false)
    public String dataFileCharacterSeparator = ",";
    public String createTablePolicy;
    public SubstringMatchType substringMatchType;
    @XNode(value="autoincrementIdField")
    public Boolean autoincrementIdField;
    @XNode(value="readOnly")
    public Boolean readOnly;
    @XNode(value="passwordField")
    private String passwordField;
    @XNode(value="passwordHashAlgorithm")
    public String passwordHashAlgorithm;
    @XNode(value="querySizeLimit")
    private Integer querySizeLimit;
    @XNodeList(value="references/tableReference", type=TableReference[].class, componentType=TableReference.class)
    private TableReference[] tableReferences;
    @XNodeList(value="references/inverseReference", type=InverseReference[].class, componentType=InverseReference.class)
    private InverseReference[] inverseReferences;
    @XNode(value="@remove")
    private boolean remove = false;
    @XNode(value="cacheTimeout")
    public Integer cacheTimeout;
    @XNode(value="cacheMaxSize")
    public Integer cacheMaxSize;
    @XNodeList(value="filters/staticFilter", type=SQLStaticFilter[].class, componentType=SQLStaticFilter.class)
    private SQLStaticFilter[] staticFilters;
    @XNode(value="nativeCase")
    public Boolean nativeCase;
    @XNode(value="computeMultiTenantId")
    private boolean computeMultiTenantId = true;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public char getDataFileCharacterSeparator() {
        if (this.dataFileCharacterSeparator == null || this.dataFileCharacterSeparator.length() == 0) {
            log.info((Object)"Character separator not well set will take the default value, \",\"");
            return ',';
        }
        if (this.dataFileCharacterSeparator.length() > 1) {
            log.warn((Object)("More than one character found for character separator, will take the first one \"" + this.dataFileCharacterSeparator.charAt(0) + "\""));
        }
        return this.dataFileCharacterSeparator.charAt(0);
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getCreateTablePolicy() {
        return this.createTablePolicy;
    }

    @XNode(value="createTablePolicy")
    public void setCreateTablePolicy(String createTablePolicy) throws DirectoryException {
        if (createTablePolicy == null) {
            this.createTablePolicy = DEFAULT_POLICY;
            return;
        }
        createTablePolicy = createTablePolicy.toLowerCase();
        boolean validPolicy = false;
        for (String policy : SCRIPT_POLICIES) {
            if (!createTablePolicy.equals(policy)) continue;
            validPolicy = true;
            break;
        }
        if (!validPolicy) {
            throw new DirectoryException("invalid value for createTablePolicy: " + createTablePolicy + ". It should be one of 'never', " + "'on_missing_columns',  or 'always'.");
        }
        this.createTablePolicy = createTablePolicy;
    }

    @XNode(value="substringMatchType")
    public void setSubstringMatchType(String substringMatchType) {
        if (substringMatchType != null) {
            try {
                this.substringMatchType = Enum.valueOf(SubstringMatchType.class, substringMatchType);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("Invalid substring match type: " + substringMatchType + ". Valid options: subinitial, subfinal, subany"));
                this.substringMatchType = SubstringMatchType.subinitial;
            }
        }
    }

    public Reference[] getInverseReferences() {
        return this.inverseReferences;
    }

    public Reference[] getTableReferences() {
        return this.tableReferences;
    }

    public Boolean getReadOnly() {
        return this.readOnly == null ? Boolean.valueOf(false) : this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isAutoincrementIdField() {
        return this.autoincrementIdField == null ? false : this.autoincrementIdField;
    }

    public void setAutoincrementIdField(boolean autoincrementIdField) {
        this.autoincrementIdField = autoincrementIdField;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setInverseReferences(InverseReference[] inverseReferences) {
        this.inverseReferences = inverseReferences;
    }

    public void setDataFileName(String dataFile) {
        this.dataFileName = dataFile;
    }

    public void setTableReferences(TableReference[] tableReferences) {
        this.tableReferences = tableReferences;
    }

    public int getQuerySizeLimit() {
        return this.querySizeLimit == null ? 0 : this.querySizeLimit;
    }

    public void setQuerySizeLimit(int querySizeLimit) {
        this.querySizeLimit = querySizeLimit;
    }

    public void setRemove(boolean delete) {
        this.remove = delete;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout == null ? 0 : this.cacheTimeout;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize == null ? 0 : this.cacheMaxSize;
    }

    public SubstringMatchType getSubstringMatchType() {
        return this.substringMatchType == null ? SubstringMatchType.subinitial : this.substringMatchType;
    }

    public void setSubstringMatchType(SubstringMatchType substringMatchType) {
        this.substringMatchType = substringMatchType;
    }

    public SQLStaticFilter[] getStaticFilters() {
        if (this.staticFilters == null) {
            return new SQLStaticFilter[0];
        }
        return this.staticFilters;
    }

    public boolean isComputeMultiTenantId() {
        return this.computeMultiTenantId;
    }

    public void merge(SQLDirectoryDescriptor other) {
        this.merge(other, false);
    }

    public void merge(SQLDirectoryDescriptor other, boolean overwite) {
        if (other.dataSourceName != null || overwite) {
            this.dataSourceName = other.dataSourceName;
        }
        if (other.dbDriver != null || overwite) {
            this.dbDriver = other.dbDriver;
        }
        if (other.dbUrl != null || overwite) {
            this.dbUrl = other.dbUrl;
        }
        if (other.dbUser != null || overwite) {
            this.dbUser = other.dbUser;
        }
        if (other.dbPassword != null || overwite) {
            this.dbPassword = other.dbPassword;
        }
        if (other.tableName != null || overwite) {
            this.tableName = other.tableName;
        }
        if (other.schemaName != null || overwite) {
            this.schemaName = other.schemaName;
        }
        if (other.parentDirectory != null || overwite) {
            this.parentDirectory = other.parentDirectory;
        }
        if (other.initDependencies != null && other.initDependencies.size() != 0 || overwite) {
            this.initDependencies = other.initDependencies;
        }
        if (other.idField != null || overwite) {
            this.idField = other.idField;
        }
        if (other.dataFileName != null || overwite) {
            this.dataFileName = other.dataFileName;
        }
        if (other.dataFileCharacterSeparator != null || overwite) {
            this.dataFileCharacterSeparator = other.dataFileCharacterSeparator;
        }
        if (other.createTablePolicy != null || overwite) {
            this.createTablePolicy = other.createTablePolicy;
        }
        if (other.substringMatchType != null || overwite) {
            this.substringMatchType = other.substringMatchType;
        }
        if (other.autoincrementIdField != null || overwite) {
            this.autoincrementIdField = other.autoincrementIdField;
        }
        if (other.readOnly != null || overwite) {
            this.readOnly = other.readOnly;
        }
        if (other.passwordField != null || overwite) {
            this.passwordField = other.passwordField;
        }
        if (other.passwordHashAlgorithm != null || overwite) {
            this.passwordHashAlgorithm = other.passwordHashAlgorithm;
        }
        if (other.querySizeLimit != null || overwite) {
            this.querySizeLimit = other.querySizeLimit;
        }
        if (other.inverseReferences != null && other.inverseReferences.length != 0 || overwite) {
            this.inverseReferences = other.inverseReferences;
        }
        if (other.tableReferences != null && other.tableReferences.length != 0 || overwite) {
            this.tableReferences = other.tableReferences;
        }
        this.remove = other.remove;
        if (other.cacheTimeout != null || overwite) {
            this.cacheTimeout = other.cacheTimeout;
        }
        if (other.cacheMaxSize != null || overwite) {
            this.cacheMaxSize = other.cacheMaxSize;
        }
        if (other.staticFilters != null && other.staticFilters.length != 0 || overwite) {
            this.staticFilters = other.staticFilters;
        }
        if (other.nativeCase != null || overwite) {
            this.nativeCase = other.nativeCase;
        }
        this.computeMultiTenantId = other.computeMultiTenantId;
    }

    public SQLDirectoryDescriptor clone() {
        int i;
        SQLDirectoryDescriptor clone = new SQLDirectoryDescriptor();
        clone.name = this.name;
        clone.schemaName = this.schemaName;
        clone.parentDirectory = this.parentDirectory;
        clone.dataSourceName = this.dataSourceName;
        clone.dbDriver = this.dbDriver;
        clone.dbUrl = this.dbUrl;
        clone.dbUser = this.dbUser;
        clone.dbPassword = this.dbPassword;
        clone.tableName = this.tableName;
        if (this.initDependencies != null) {
            clone.initDependencies = new ArrayList<String>(this.initDependencies);
        }
        clone.idField = this.idField;
        clone.dataFileName = this.dataFileName;
        clone.dataFileCharacterSeparator = this.dataFileCharacterSeparator;
        clone.createTablePolicy = this.createTablePolicy;
        clone.substringMatchType = this.substringMatchType;
        clone.autoincrementIdField = this.autoincrementIdField;
        clone.readOnly = this.readOnly;
        clone.passwordField = this.passwordField;
        clone.passwordHashAlgorithm = this.passwordHashAlgorithm;
        clone.querySizeLimit = this.querySizeLimit;
        if (this.tableReferences != null) {
            clone.tableReferences = new TableReference[this.tableReferences.length];
            for (i = 0; i < this.tableReferences.length; ++i) {
                clone.tableReferences[i] = this.tableReferences[i].clone();
            }
        }
        if (this.inverseReferences != null) {
            clone.inverseReferences = new InverseReference[this.inverseReferences.length];
            for (i = 0; i < this.inverseReferences.length; ++i) {
                clone.inverseReferences[i] = this.inverseReferences[i].clone();
            }
        }
        clone.remove = this.remove;
        clone.cacheTimeout = this.cacheTimeout;
        clone.cacheMaxSize = this.cacheMaxSize;
        if (this.staticFilters != null) {
            clone.staticFilters = new SQLStaticFilter[this.staticFilters.length];
            for (i = 0; i < this.staticFilters.length; ++i) {
                clone.staticFilters[i] = this.staticFilters[i].clone();
            }
        }
        clone.nativeCase = this.nativeCase;
        clone.computeMultiTenantId = this.computeMultiTenantId;
        return clone;
    }

    public static enum SubstringMatchType {
        subinitial,
        subfinal,
        subany;

    }
}

