/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.storage.sql.ColumnSpec;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.utils.SIDGenerator;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.ecm.directory.OperationNotAllowedException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.directory.sql.PasswordHelper;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;
import org.nuxeo.ecm.directory.sql.filter.SQLComplexFilter;

public class SQLSession
extends BaseSession
implements EntrySource {
    private static final String READ_ONLY_VOCABULARY_WARN = "This SQLDirectory is ReadOnly, you are not allowed to modify it.";
    private static final Log log = LogFactory.getLog(SQLSession.class);
    protected final Map<String, Field> schemaFieldMap;
    protected final List<String> storedFieldNames;
    protected final Set<String> emptySet = Collections.emptySet();
    final String schemaName;
    final Table table;
    private final SQLDirectoryDescriptor.SubstringMatchType substringMatchType;
    String dataSourceName;
    final String idField;
    final String passwordField;
    final String passwordHashAlgorithm;
    private final boolean autoincrementIdField;
    private final boolean computeMultiTenantId;
    final SQLDirectory directory;
    protected SQLStaticFilter[] staticFilters;
    String sid;
    Connection sqlConnection;
    private final boolean managedSQLSession;
    private final Dialect dialect;
    protected JDBCLogger logger = new JDBCLogger("SQLDirectory");

    public SQLSession(SQLDirectory directory, SQLDirectoryDescriptor config, boolean managedSQLSession) throws DirectoryException {
        this.directory = directory;
        this.schemaName = config.getSchemaName();
        this.table = directory.getTable();
        this.idField = config.getIdField();
        this.passwordField = config.getPasswordField();
        this.passwordHashAlgorithm = config.passwordHashAlgorithm;
        this.schemaFieldMap = directory.getSchemaFieldMap();
        this.storedFieldNames = directory.getStoredFieldNames();
        this.dialect = directory.getDialect();
        this.sid = String.valueOf(SIDGenerator.next());
        this.managedSQLSession = managedSQLSession;
        this.substringMatchType = config.getSubstringMatchType();
        this.autoincrementIdField = config.isAutoincrementIdField();
        this.staticFilters = config.getStaticFilters();
        this.computeMultiTenantId = config.isComputeMultiTenantId();
        this.acquireConnection();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    protected DocumentModel fieldMapToDocumentModel(Map<String, Object> fieldMap) {
        String id = String.valueOf(fieldMap.get(this.getIdField()));
        try {
            DocumentModel docModel = BaseSession.createEntryModel((String)this.sid, (String)this.schemaName, (String)id, fieldMap, (boolean)this.isReadOnly());
            return docModel;
        }
        catch (PropertyException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private void acquireConnection() throws DirectoryException {
        try {
            if (this.sqlConnection == null || this.sqlConnection.isClosed()) {
                this.sqlConnection = this.directory.getConnection();
                if (!this.managedSQLSession) {
                    this.sqlConnection.setAutoCommit(true);
                }
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot connect to SQL directory '" + this.directory.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) throws ClientException {
        DocumentModel entry;
        if (this.isReadOnly()) {
            log.warn((Object)READ_ONLY_VOCABULARY_WARN);
        }
        this.acquireConnection();
        if (this.autoincrementIdField) {
            fieldMap.remove(this.idField);
        } else {
            String tenantId;
            Object rawId = fieldMap.get(this.idField);
            if (rawId == null) {
                throw new DirectoryException("Missing id");
            }
            String id = String.valueOf(rawId);
            if (this.hasEntry(id)) {
                throw new DirectoryException(String.format("Entry with id %s already exists", id));
            }
            if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId()))) {
                fieldMap.put("tenantId", tenantId);
                if (this.computeMultiTenantId) {
                    fieldMap.put(this.idField, SQLSession.computeMultiTenantDirectoryId((String)tenantId, (String)id));
                }
            }
        }
        ArrayList columnList = new ArrayList(this.table.getColumns());
        Iterator i = columnList.iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            if (fieldMap.get(column.getKey()) != null) continue;
            i.remove();
        }
        Insert insert = new Insert(this.table);
        for (Column column : columnList) {
            insert.addColumn(column);
        }
        String sql = insert.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<Serializable> values = new ArrayList<Serializable>(columnList.size());
            for (Column column : columnList) {
                Object value = fieldMap.get(column.getKey());
                values.add(this.fieldValueForWrite(value, column));
            }
            this.logger.logSQL(sql, values);
        }
        Statement ps = null;
        Statement st = null;
        try {
            ps = this.autoincrementIdField && this.dialect.hasIdentityGeneratedKey() ? this.sqlConnection.prepareStatement(sql, new String[]{this.idField}) : this.sqlConnection.prepareStatement(sql);
            int index = 1;
            for (Column column : columnList) {
                Object value = fieldMap.get(column.getKey());
                this.setFieldValue((PreparedStatement)ps, index, column, value);
                ++index;
            }
            ps.execute();
            if (this.autoincrementIdField) {
                ResultSet rs;
                Column column = this.table.getColumn(this.idField);
                if (this.dialect.hasIdentityGeneratedKey()) {
                    rs = ps.getGeneratedKeys();
                } else {
                    sql = this.dialect.getIdentityGeneratedKeySql(column);
                    st = this.sqlConnection.createStatement();
                    rs = st.executeQuery(sql);
                }
                if (!rs.next()) {
                    throw new DirectoryException("Cannot get generated key");
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logResultSet(rs, Collections.singletonList(column));
                }
                Serializable rawId = column.getFromResultSet(rs, 1);
                fieldMap.put(this.idField, rawId);
                rs.close();
            }
            entry = this.fieldMapToDocumentModel(fieldMap);
        }
        catch (SQLException e) {
            throw new DirectoryException("createEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
        String sourceId = entry.getId();
        for (Reference reference : this.getDirectory().getReferences()) {
            List targetIds = (List)fieldMap.get(reference.getFieldName());
            if (reference instanceof TableReference) {
                TableReference tableReference = (TableReference)reference;
                tableReference.maybeInitialize(this);
                tableReference.addLinks(sourceId, targetIds, this);
                continue;
            }
            reference.addLinks(sourceId, targetIds);
        }
        this.directory.invalidateCaches();
        return entry;
    }

    public DocumentModel getEntry(String id) throws DirectoryException {
        return this.getEntry(id, true);
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        return this.directory.getCache().getEntry(id, (EntrySource)this, fetchReferences);
    }

    protected String addFilterWhereClause(String whereClause) throws DirectoryException {
        if (this.staticFilters.length == 0) {
            return whereClause;
        }
        whereClause = whereClause != null && whereClause.trim().length() > 0 ? whereClause + " AND " : "";
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            whereClause = whereClause + filter.getDirectoryColumn(this.table, this.directory.useNativeCase()).getQuotedName();
            whereClause = whereClause + " " + filter.getOperator() + " ";
            whereClause = whereClause + "? ";
            if (i >= this.staticFilters.length - 1) continue;
            whereClause = whereClause + " AND ";
        }
        return whereClause;
    }

    protected void addFilterValues(PreparedStatement ps, int startIdx) throws DirectoryException {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            SQLStaticFilter filter = this.staticFilters[i];
            this.setFieldValue(ps, startIdx + i, filter.getDirectoryColumn(this.table, this.directory.useNativeCase()), filter.getValue());
        }
    }

    protected void addFilterValuesForLog(List<Serializable> values) {
        for (int i = 0; i < this.staticFilters.length; ++i) {
            values.add((Serializable)((Object)this.staticFilters[i].getValue()));
        }
    }

    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) throws DirectoryException {
        this.acquireConnection();
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        select.setWhat("*");
        String whereClause = this.table.getPrimaryColumn().getQuotedName() + " = ?";
        whereClause = this.addFilterWhereClause(whereClause);
        select.setWhere(whereClause);
        String sql = select.getStatement();
        if (this.logger.isLogEnabled()) {
            ArrayList<Serializable> values = new ArrayList<Serializable>();
            values.add((Serializable)((Object)id));
            this.addFilterValuesForLog(values);
            this.logger.logSQL(sql, values);
        }
        PreparedStatement ps = null;
        try {
            String entryTenantId;
            String tenantId;
            Object value;
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
            this.addFilterValues(ps, 2);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                DocumentModel documentModel = null;
                return documentModel;
            }
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            for (String fieldName : this.storedFieldNames) {
                value = this.getFieldValue(rs, fieldName);
                fieldMap.put(fieldName, value);
            }
            if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId())) && !StringUtils.isBlank((String)(entryTenantId = (String)fieldMap.get("tenantId"))) && !entryTenantId.equals(tenantId)) {
                value = null;
                return value;
            }
            DocumentModel entry = this.fieldMapToDocumentModel(fieldMap);
            if (fetchReferences) {
                for (Reference reference : this.directory.getReferences()) {
                    List targetIds = reference.getTargetIdsForSource(entry.getId());
                    try {
                        entry.setProperty(this.schemaName, reference.getFieldName(), (Object)targetIds);
                    }
                    catch (ClientException e) {
                        throw new DirectoryException((Throwable)e);
                    }
                }
            }
            DocumentModel documentModel = entry;
            return documentModel;
        }
        catch (SQLException e) {
            throw new DirectoryException("getEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public DocumentModelList getEntries() throws ClientException {
        Map<String, Serializable> emptyMap = Collections.emptyMap();
        return this.query(emptyMap);
    }

    public void updateEntry(DocumentModel docModel) throws ClientException {
        String entryTenantId;
        String tenantId;
        if (this.isReadOnly()) {
            log.warn((Object)READ_ONLY_VOCABULARY_WARN);
            return;
        }
        this.acquireConnection();
        LinkedList<Column> storedColumnList = new LinkedList<Column>();
        LinkedList<String> referenceFieldList = new LinkedList<String>();
        DataModel dataModel = docModel.getDataModel(this.schemaName);
        if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId())) && (StringUtils.isBlank((String)(entryTenantId = (String)dataModel.getValue("tenantId"))) || !entryTenantId.equals(tenantId))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Trying to update entry '%s' not part of current tenant '%s'", docModel.getId(), tenantId));
            }
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        for (String fieldName : this.schemaFieldMap.keySet()) {
            if (fieldName.equals(this.idField) || !dataModel.isDirty(fieldName)) continue;
            if (this.directory.isReference(fieldName)) {
                referenceFieldList.add(fieldName);
                continue;
            }
            storedColumnList.add(this.table.getColumn(fieldName));
        }
        if (!storedColumnList.isEmpty()) {
            Update update = new Update(this.table);
            update.setUpdatedColumns(storedColumnList);
            String whereString = this.table.getPrimaryColumn().getQuotedName() + " = ?";
            update.setWhere(whereString);
            String sql = update.getStatement();
            if (this.logger.isLogEnabled()) {
                ArrayList<Object> values = new ArrayList<Object>(storedColumnList.size());
                for (Column column : storedColumnList) {
                    Object value = dataModel.getData(column.getKey());
                    values.add((Serializable)value);
                }
                values.add(docModel.getId());
                this.logger.logSQL(sql, values);
            }
            PreparedStatement ps = null;
            try {
                ps = this.sqlConnection.prepareStatement(sql);
                int index = 1;
                for (Column column : storedColumnList) {
                    Object value = dataModel.getData(column.getKey());
                    this.setFieldValue(ps, index, column, value);
                    ++index;
                }
                this.setFieldValue(ps, index, this.table.getPrimaryColumn(), docModel.getId());
                ps.execute();
            }
            catch (SQLException e) {
                throw new DirectoryException("updateEntry failed for " + docModel.getId(), (Throwable)e);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sqle) {
                    throw new DirectoryException((Throwable)sqle);
                }
            }
        }
        for (String referenceFieldName : referenceFieldList) {
            Reference reference = this.directory.getReference(referenceFieldName);
            List targetIds = (List)docModel.getProperty(this.schemaName, referenceFieldName);
            if (reference instanceof TableReference) {
                TableReference tableReference = (TableReference)reference;
                tableReference.setTargetIdsForSource(docModel.getId(), targetIds, this);
                continue;
            }
            reference.setTargetIdsForSource(docModel.getId(), targetIds);
        }
        this.directory.invalidateCaches();
    }

    public void deleteEntry(DocumentModel docModel) throws ClientException {
        this.deleteEntry(docModel.getId());
    }

    public void deleteEntry(String id) throws ClientException {
        this.acquireConnection();
        if (this.isReadOnly()) {
            log.warn((Object)READ_ONLY_VOCABULARY_WARN);
            return;
        }
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        for (Reference reference : this.getDirectory().getReferences()) {
            if (reference instanceof TableReference) {
                TableReference tableReference = (TableReference)reference;
                tableReference.removeLinksForSource(id, this);
                continue;
            }
            reference.removeLinksForSource(id);
        }
        Statement ps = null;
        try {
            Delete delete = new Delete(this.table);
            String whereString = this.table.getPrimaryColumn().getQuotedName() + " = ?";
            delete.setWhere(whereString);
            String sql = delete.getStatement();
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singleton(id));
            }
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue((PreparedStatement)ps, 1, this.table.getPrimaryColumn(), id);
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
        this.directory.invalidateCaches();
    }

    protected boolean canDeleteMultiTenantEntry(String entryId) throws DirectoryException {
        String tenantId;
        if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId()))) {
            try {
                DocumentModel entry = this.getEntry(entryId);
                DataModel dataModel = entry.getDataModel(this.schemaName);
                String entryTenantId = (String)dataModel.getValue("tenantId");
                if (StringUtils.isBlank((String)entryTenantId) || !entryTenantId.equals(tenantId)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Trying to delete entry '%s' not part of current tenant '%s'", entryId, tenantId));
                    }
                    return false;
                }
            }
            catch (ClientException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        return true;
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        if (this.isReadOnly()) {
            log.warn((Object)READ_ONLY_VOCABULARY_WARN);
            return;
        }
        this.acquireConnection();
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new DirectoryException("Operation not allowed in the current tenant context");
        }
        Statement ps = null;
        try {
            Delete delete = new Delete(this.table);
            StringBuilder whereClause = new StringBuilder();
            ArrayList<String> values = new ArrayList<String>(1 + map.size());
            whereClause.append(this.table.getPrimaryColumn().getQuotedName());
            whereClause.append(" = ?");
            values.add(id);
            for (Map.Entry<String, String> e : map.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                whereClause.append(" AND ");
                Column col = this.table.getColumn(key);
                if (col == null) {
                    throw new IllegalArgumentException("Unknown column " + key);
                }
                whereClause.append(col.getQuotedName());
                if (value == null) {
                    whereClause.append(" IS NULL");
                    continue;
                }
                whereClause.append(" = ?");
                values.add(value);
            }
            delete.setWhere(whereClause.toString());
            String sql = delete.getStatement();
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, values);
            }
            ps = this.sqlConnection.prepareStatement(sql);
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    this.setFieldValue((PreparedStatement)ps, 1, this.table.getPrimaryColumn(), values.get(i));
                    continue;
                }
                ps.setString(1 + i, (String)values.get(i));
            }
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException("deleteEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
        this.directory.invalidateCaches();
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws ClientException {
        return this.query(filter, fulltext, orderBy, false);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws ClientException {
        return this.query(filter, fulltext, orderBy, fetchReferences, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws ClientException, DirectoryException {
        DocumentModelListImpl documentModelListImpl;
        block45: {
            String tenantId;
            this.acquireConnection();
            LinkedHashMap<String, Object> filterMap = new LinkedHashMap<String, Object>(filter);
            if (this.isMultiTenant() && !StringUtils.isBlank((String)(tenantId = this.getCurrentTenantId()))) {
                filterMap.put("tenantId", (Serializable)((Object)tenantId));
            }
            StringBuilder whereClause = new StringBuilder();
            String separator = "";
            LinkedList<Column> orderedColumns = new LinkedList<Column>();
            for (String columnName : filterMap.keySet()) {
                String operator;
                boolean substring;
                if (this.directory.isReference(columnName)) {
                    log.warn((Object)(columnName + " is a reference and will be ignored" + " as a query criterion"));
                    continue;
                }
                Object value = filterMap.get(columnName);
                Column column = this.table.getColumn(columnName);
                if (null == column) {
                    throw new ClientException("cannot find column '" + columnName + "' for table: " + this.table);
                }
                String leftSide = column.getQuotedName();
                String rightSide = "?";
                boolean bl = substring = fulltext != null && fulltext.contains(columnName);
                if ("".equals(value) && this.dialect.hasNullEmptyString() && !substring) {
                    value = null;
                }
                if (value != null) {
                    if (value instanceof SQLComplexFilter) {
                        SQLComplexFilter complexFilter = (SQLComplexFilter)value;
                        operator = complexFilter.getOperator();
                        rightSide = complexFilter.getRightSide();
                    } else if (substring) {
                        String searchedValue = null;
                        switch (this.substringMatchType) {
                            case subany: {
                                searchedValue = '%' + String.valueOf(value).toLowerCase() + '%';
                                break;
                            }
                            case subinitial: {
                                searchedValue = String.valueOf(value).toLowerCase() + '%';
                                break;
                            }
                            case subfinal: {
                                searchedValue = '%' + String.valueOf(value).toLowerCase();
                            }
                        }
                        filterMap.put(columnName, searchedValue);
                        if (this.dialect.supportsIlike()) {
                            operator = " ILIKE ";
                        } else {
                            leftSide = "LOWER(" + leftSide + ')';
                            operator = " LIKE ";
                        }
                    } else {
                        operator = " = ";
                    }
                } else {
                    operator = " IS NULL";
                }
                whereClause.append(separator).append(leftSide).append(operator);
                if (value != null) {
                    whereClause.append(rightSide);
                    orderedColumns.add(column);
                }
                separator = " AND ";
            }
            int queryLimitSize = this.directory.getConfig().getQuerySizeLimit();
            if (queryLimitSize != 0 && (limit <= 0 || limit > queryLimitSize)) {
                try (Statement ps = null;){
                    Select select = new Select(this.table);
                    select.setWhat("count(*)");
                    select.setFrom(this.table.getQuotedName());
                    String where = whereClause.toString();
                    where = this.addFilterWhereClause(where);
                    select.setWhere(where);
                    String countQuery = select.getStatement();
                    ps = this.sqlConnection.prepareStatement(countQuery);
                    this.fillPreparedStatementFields(filterMap, orderedColumns, (PreparedStatement)ps);
                    ResultSet rs = ps.executeQuery();
                    rs.next();
                    int count = rs.getInt(1);
                    if (count > queryLimitSize) {
                        throw new SizeLimitExceededException("too many rows in result: " + count);
                    }
                }
            }
            Select select = new Select(this.table);
            select.setWhat("*");
            select.setFrom(this.table.getQuotedName());
            String where = whereClause.toString();
            where = this.addFilterWhereClause(where);
            select.setWhere(where);
            StringBuilder orderby = new StringBuilder(128);
            if (orderBy != null) {
                Iterator<Map.Entry<String, String>> it = orderBy.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    orderby.append(this.dialect.openQuote()).append(entry.getKey()).append(this.dialect.closeQuote()).append(' ').append(entry.getValue());
                    if (!it.hasNext()) continue;
                    orderby.append(',');
                }
            }
            select.setOrderBy(orderby.toString());
            String query = select.getStatement();
            if (limit > 0) {
                if (!this.dialect.supportsPaging()) {
                    throw new UnsupportedOperationException("Trying to use paging with an unsupported dialect: " + this.dialect.getClass().getName());
                }
                if (offset < 0) {
                    offset = 0;
                }
                query = this.dialect.addPagingClause(query, (long)limit, (long)offset);
            }
            if (this.logger.isLogEnabled()) {
                ArrayList<Serializable> values = new ArrayList<Serializable>(orderedColumns.size());
                for (Column column : orderedColumns) {
                    Object value = filterMap.get(column.getKey());
                    values.add((Serializable)value);
                }
                this.addFilterValuesForLog(values);
                this.logger.logSQL(query, values);
            }
            PreparedStatement ps = null;
            try {
                ps = this.sqlConnection.prepareStatement(query);
                this.fillPreparedStatementFields(filterMap, orderedColumns, ps);
                ResultSet rs = ps.executeQuery();
                DocumentModelListImpl list = new DocumentModelListImpl();
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String fieldName : this.storedFieldNames) {
                        Object o = this.getFieldValue(rs, fieldName);
                        map.put(fieldName, o);
                    }
                    DocumentModel docModel = this.fieldMapToDocumentModel(map);
                    if (fetchReferences) {
                        for (Reference reference : this.directory.getReferences()) {
                            List targetIds = reference.getTargetIdsForSource(docModel.getId());
                            docModel.setProperty(this.schemaName, reference.getFieldName(), (Object)targetIds);
                        }
                    }
                    list.add((Object)docModel);
                }
                documentModelListImpl = list;
                if (ps == null) break block45;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    try {
                        this.sqlConnection.close();
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    throw new DirectoryException("query failed", (Throwable)e);
                }
            }
            ps.close();
        }
        return documentModelListImpl;
    }

    protected void fillPreparedStatementFields(Map<String, Object> filterMap, List<Column> orderedColumns, PreparedStatement ps) throws DirectoryException {
        int index = 1;
        for (Column column : orderedColumns) {
            Object value = filterMap.get(column.getKey());
            if (value instanceof SQLComplexFilter) {
                index = ((SQLComplexFilter)value).setFieldValue(ps, index, column);
                continue;
            }
            this.setFieldValue(ps, index, column, value);
            ++index;
        }
        this.addFilterValues(ps, index);
    }

    public DocumentModelList query(Map<String, Serializable> filter) throws ClientException {
        return this.query(filter, this.emptySet);
    }

    private Object getFieldValue(ResultSet rs, String fieldName) throws DirectoryException {
        try {
            Column column = this.table.getColumn(fieldName);
            if (column == null) {
                throw new DirectoryException(String.format("Column '%s' does not exist in table '%s'", fieldName, this.table.getKey()));
            }
            int index = rs.findColumn(column.getPhysicalName());
            return column.getFromResultSet(rs, index);
        }
        catch (SQLException e) {
            throw new DirectoryException("getFieldValue failed", (Throwable)e);
        }
    }

    private void setFieldValue(PreparedStatement ps, int index, Column column, Object value) throws DirectoryException {
        try {
            column.setToPreparedStatement(ps, index, this.fieldValueForWrite(value, column));
        }
        catch (SQLException e) {
            throw new DirectoryException("setFieldValue failed", (Throwable)e);
        }
    }

    protected Serializable fieldValueForWrite(Object value, Column column) {
        ColumnSpec spec = column.getType().spec;
        if (value instanceof String) {
            if (spec == ColumnSpec.LONG || spec == ColumnSpec.AUTOINC) {
                return Long.valueOf((String)value);
            }
            if (column.getKey().equals(this.passwordField)) {
                String password = (String)value;
                if (!PasswordHelper.isHashed(password)) {
                    password = PasswordHelper.hashPassword(password, this.passwordHashAlgorithm);
                }
                return password;
            }
        } else if (value instanceof Number) {
            if (spec == ColumnSpec.LONG || spec == ColumnSpec.AUTOINC) {
                if (value instanceof Integer) {
                    return Long.valueOf(((Integer)value).longValue());
                }
            } else if (spec == ColumnSpec.STRING) {
                return value.toString();
            }
        }
        return (Serializable)value;
    }

    public void commit() throws DirectoryException {
    }

    public void rollback() throws DirectoryException {
    }

    public void close() throws DirectoryException {
        try {
            if (!this.sqlConnection.isClosed()) {
                this.sqlConnection.close();
            }
        }
        catch (SQLException e) {
            throw new DirectoryException("close failed", (Throwable)e);
        }
        finally {
            this.directory.removeSession((Session)this);
        }
    }

    public boolean isLive() throws DirectoryException {
        try {
            return !this.sqlConnection.isClosed();
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot check connection status of " + (Object)((Object)this), (Throwable)e);
        }
    }

    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws ClientException {
        DocumentModelList docList = this.query(filter, fulltext);
        ArrayList<String> result = new ArrayList<String>();
        for (DocumentModel docModel : docList) {
            Object obj = docModel.getProperty(this.schemaName, columnName);
            String propValue = obj instanceof String ? (String)obj : String.valueOf(obj);
            result.add(propValue);
        }
        return result;
    }

    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws ClientException {
        return this.getProjection(filter, this.emptySet, columnName);
    }

    public boolean authenticate(String username, String password) throws ClientException {
        DocumentModel entry = this.getEntry(username);
        if (entry == null) {
            return false;
        }
        String storedPassword = (String)entry.getProperty(this.schemaName, this.getPasswordField());
        return PasswordHelper.verifyPassword(password, storedPassword);
    }

    public boolean isAuthenticating() throws ClientException {
        return this.schemaFieldMap.containsKey(this.getPasswordField());
    }

    public String getIdField() {
        return this.directory.getConfig().getIdField();
    }

    public String getPasswordField() {
        return this.directory.getConfig().getPasswordField();
    }

    public boolean isReadOnly() {
        return Boolean.TRUE.equals(this.directory.getConfig().getReadOnly());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) throws ClientException {
        return this.query(filter, fulltext, new HashMap<String, String>());
    }

    public DocumentModel createEntry(DocumentModel entry) throws ClientException {
        Map fieldMap = entry.getProperties(this.schemaName);
        return this.createEntry(fieldMap);
    }

    public boolean hasEntry(String id) throws ClientException {
        this.acquireConnection();
        Select select = new Select(this.table);
        select.setFrom(this.table.getQuotedName());
        select.setWhat("*");
        select.setWhere(this.table.getPrimaryColumn().getQuotedName() + " = ?");
        String sql = select.getStatement();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singleton(id));
        }
        PreparedStatement ps = null;
        try {
            ps = this.sqlConnection.prepareStatement(sql);
            this.setFieldValue(ps, 1, this.table.getPrimaryColumn(), id);
            ResultSet rs = ps.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new DirectoryException("hasEntry failed", (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public Connection getSqlConnection() {
        return this.sqlConnection;
    }

    protected boolean isMultiTenant() {
        return this.directory.isMultiTenant();
    }

    protected String getCurrentTenantId() {
        NuxeoPrincipal principal = ClientLoginModule.getCurrentPrincipal();
        return principal != null ? principal.getTenantId() : null;
    }

    public String toString() {
        return "SQLSession [directory=" + this.directory.getName() + ", sid=" + this.sid + "]";
    }
}

