/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.File;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStream;

public class ThresholdOutputStreamFactory {
    private File tempDir;
    private int memoryThreshold;
    private long maxContentSize;
    private boolean encrypt;

    private ThresholdOutputStreamFactory(File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        this.tempDir = tempDir;
        this.memoryThreshold = memoryThreshold;
        this.maxContentSize = maxContentSize;
        this.encrypt = encrypt;
    }

    public static ThresholdOutputStreamFactory newInstance(File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        return new ThresholdOutputStreamFactory(tempDir, memoryThreshold, maxContentSize, encrypt);
    }

    public ThresholdOutputStream newOutputStream() {
        return new ThresholdOutputStream(this.tempDir, this.memoryThreshold, this.maxContentSize, this.encrypt);
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public long getMaxContentSize() {
        return this.maxContentSize;
    }

    public boolean isEncrypted() {
        return this.encrypt;
    }
}

