/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;

@Operation(id="FileManager.Import", category="Services", label="Create Document from file", description="Create Document(s) from Blob(s) using the FileManagerService.")
public class FileManagerImport {
    public static final String ID = "FileManager.Import";
    @Context
    protected CoreSession session;
    @Context
    protected FileManager fileManager;
    @Context
    protected AutomationService as;
    @Context
    protected OperationContext context;
    @Param(name="overwite", required=false)
    protected Boolean overwite = false;

    protected DocumentModel getCurrentDocument() throws Exception {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws Exception {
        DocumentModel currentDocument = this.getCurrentDocument();
        return this.fileManager.createDocumentFromBlob(this.session, blob, currentDocument.getPathAsString(), this.overwite.booleanValue(), blob.getFilename());
    }

    @OperationMethod
    public DocumentModelList run(BlobList blobs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (Blob blob : blobs) {
            result.add((Object)this.run(blob));
        }
        return result;
    }
}

