/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.authz.GroupCache;
import org.apache.directory.server.core.authz.TupleCache;
import org.apache.directory.server.core.authz.support.ACDFEngine;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.subtree.SubentryService;
import org.apache.directory.server.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationService.class);
    private static final String AC_SUBENTRY_ATTR = "accessControlSubentries";
    private static final Collection<MicroOperation> ADD_PERMS;
    private static final Collection<MicroOperation> READ_PERMS;
    private static final Collection<MicroOperation> COMPARE_PERMS;
    private static final Collection<MicroOperation> SEARCH_ENTRY_PERMS;
    private static final Collection<MicroOperation> SEARCH_ATTRVAL_PERMS;
    private static final Collection<MicroOperation> REMOVE_PERMS;
    private static final Collection<MicroOperation> MATCHEDNAME_PERMS;
    private static final Collection<MicroOperation> BROWSE_PERMS;
    private static final Collection<MicroOperation> LOOKUP_PERMS;
    private static final Collection<MicroOperation> REPLACE_PERMS;
    private static final Collection<MicroOperation> RENAME_PERMS;
    private static final Collection<MicroOperation> EXPORT_PERMS;
    private static final Collection<MicroOperation> IMPORT_PERMS;
    private static final Collection<MicroOperation> MOVERENAME_PERMS;
    private TupleCache tupleCache;
    private GroupCache groupCache;
    private ACIItemParser aciParser;
    private ACDFEngine engine;
    private InterceptorChain chain;
    private AttributeTypeRegistry attrRegistry;
    private boolean enabled = false;
    private String subschemaSubentryDn;
    private AttributeType objectClassType;
    private AttributeType acSubentryType;
    private String objectClassOid;
    private String subentryOid;
    private String acSubentryOid;
    private AttributeType entryAciType;
    private AttributeType subentryAciType;
    public static final SearchControls DEFAULT_SEARCH_CONTROLS;

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        super.init(factoryCfg, cfg);
        this.tupleCache = new TupleCache(factoryCfg);
        this.groupCache = new GroupCache(factoryCfg);
        this.attrRegistry = factoryCfg.getRegistries().getAttributeTypeRegistry();
        OidRegistry oidRegistry = factoryCfg.getRegistries().getOidRegistry();
        this.objectClassOid = oidRegistry.getOid("objectClass");
        this.subentryOid = oidRegistry.getOid("subentry");
        this.acSubentryOid = oidRegistry.getOid(AC_SUBENTRY_ATTR);
        this.objectClassType = this.attrRegistry.lookup(this.objectClassOid);
        this.acSubentryType = this.attrRegistry.lookup(this.acSubentryOid);
        this.entryAciType = this.attrRegistry.lookup("2.5.24.5");
        this.subentryAciType = this.attrRegistry.lookup("2.5.24.6");
        this.aciParser = new ACIItemParser((NameComponentNormalizer)new ConcreteNameComponentNormalizer(this.attrRegistry, oidRegistry), this.attrRegistry.getNormalizerMapping());
        this.engine = new ACDFEngine(factoryCfg.getRegistries().getOidRegistry(), this.attrRegistry);
        this.chain = factoryCfg.getInterceptorChain();
        this.enabled = factoryCfg.getStartupConfiguration().isAccessControlEnabled();
        String subschemaSubentry = (String)factoryCfg.getPartitionNexus().getRootDSE(null).get("subschemaSubentry").get();
        LdapDN subschemaSubentryDnName = new LdapDN(subschemaSubentry);
        subschemaSubentryDnName.normalize(this.attrRegistry.getNormalizerMapping());
        this.subschemaSubentryDn = subschemaSubentryDnName.toNormName();
    }

    private LdapDN parseNormalized(String name) throws NamingException {
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return dn;
    }

    private void addPerscriptiveAciTuples(PartitionNexusProxy proxy, Collection<ACITuple> tuples, LdapDN dn, Attributes entry) throws NamingException {
        Attribute subentries;
        Attribute oc = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.objectClassType);
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"subentry", (AttributeType)this.objectClassType) || AttributeUtils.containsValue((Attribute)oc, (Object)this.subentryOid, (AttributeType)this.objectClassType)) {
            LdapDN parentDn = (LdapDN)dn.clone();
            parentDn.remove(dn.size() - 1);
            entry = proxy.lookup(new LookupOperationContext(parentDn), PartitionNexusProxy.LOOKUP_BYPASS);
        }
        if ((subentries = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.acSubentryType)) == null) {
            return;
        }
        for (int ii = 0; ii < subentries.size(); ++ii) {
            String subentryDn = (String)subentries.get(ii);
            tuples.addAll(this.tupleCache.getACITuples(subentryDn));
        }
    }

    private void addEntryAciTuples(Collection<ACITuple> tuples, Attributes entry) throws NamingException {
        Attribute entryAci = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.entryAciType);
        if (entryAci == null) {
            return;
        }
        for (int ii = 0; ii < entryAci.size(); ++ii) {
            ACIItem item;
            String aciString = (String)entryAci.get(ii);
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = "failed to parse entryACI: " + aciString;
                log.error(msg, (Throwable)e);
                throw new LdapNamingException(msg, ResultCodeEnum.OPERATIONS_ERROR);
            }
            tuples.addAll(item.toTuples());
        }
    }

    private void addSubentryAciTuples(PartitionNexusProxy proxy, Collection<ACITuple> tuples, LdapDN dn, Attributes entry) throws NamingException {
        if (!AttributeUtils.containsValueCaseIgnore((Attribute)entry.get("objectClass"), (Object)"subentry")) {
            return;
        }
        LdapDN parentDn = (LdapDN)dn.clone();
        parentDn.remove(dn.size() - 1);
        Attributes administrativeEntry = proxy.lookup(new LookupOperationContext(parentDn, new String[]{"subentryACI"}), PartitionNexusProxy.LOOKUP_BYPASS);
        Attribute subentryAci = AttributeUtils.getAttribute((Attributes)administrativeEntry, (AttributeType)this.subentryAciType);
        if (subentryAci == null) {
            return;
        }
        for (int ii = 0; ii < subentryAci.size(); ++ii) {
            ACIItem item;
            String aciString = (String)subentryAci.get(ii);
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = "failed to parse subentryACI: " + aciString;
                log.error(msg, (Throwable)e);
                throw new LdapNamingException(msg, ResultCodeEnum.OPERATIONS_ERROR);
            }
            tuples.addAll(item.toTuples());
        }
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        Attributes entry = addContext.getEntry();
        LdapDN name = addContext.getDn();
        if (!this.enabled) {
            next.add(addContext);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.add(addContext);
            this.tupleCache.subentryAdded(name.getUpName(), name, entry);
            this.groupCache.groupAdded(name, entry);
            return;
        }
        SubentryService subentryService = (SubentryService)this.chain.get("subentryService");
        Attributes subentryAttrs = subentryService.getSubentryAttributes((Name)name, entry);
        NamingEnumeration<? extends Attribute> attrList = entry.getAll();
        while (attrList.hasMore()) {
            subentryAttrs.put(attrList.next());
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(invocation.getProxy(), tuples, name, subentryAttrs);
        this.addSubentryAciTuples(invocation.getProxy(), tuples, name, subentryAttrs);
        PartitionNexusProxy proxy = invocation.getProxy();
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, ADD_PERMS, tuples, subentryAttrs);
        NamingEnumeration<? extends Attribute> attributeList = entry.getAll();
        while (attributeList.hasMore()) {
            Attribute attr = attributeList.next();
            for (int ii = 0; ii < attr.size(); ++ii) {
                this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getID(), attr.get(ii), ADD_PERMS, tuples, entry);
            }
        }
        next.add(addContext);
        this.tupleCache.subentryAdded(name.getUpName(), name, entry);
        this.groupCache.groupAdded(name, entry);
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws NamingException {
        LdapDN name = deleteContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.delete(deleteContext);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.delete(deleteContext);
            this.tupleCache.subentryDeleted((Name)name, entry);
            this.groupCache.groupDeleted(name, entry);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, REMOVE_PERMS, tuples, entry);
        next.delete(deleteContext);
        this.tupleCache.subentryDeleted((Name)name, entry);
        this.groupCache.groupDeleted(name, entry);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        LdapDN name = opContext.getDn();
        Attributes entry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.modify(opContext);
            return;
        }
        ModificationItemImpl[] mods = opContext.getModItems();
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.modify(opContext);
            Attributes modifiedEntry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
            this.tupleCache.subentryModified(name, mods, modifiedEntry);
            this.groupCache.groupModified(name, mods, entry);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, Collections.singleton(MicroOperation.MODIFY), tuples, entry);
        Collection<MicroOperation> perms = null;
        for (int ii = 0; ii < mods.length; ++ii) {
            Attribute attr = mods[ii].getAttribute();
            switch (mods[ii].getModificationOp()) {
                case 1: {
                    perms = ADD_PERMS;
                    if (entry.get(attr.getID()) != null) break;
                    this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getID(), null, perms, tuples, entry);
                    break;
                }
                case 3: {
                    perms = REMOVE_PERMS;
                    Attribute entryAttr = entry.get(attr.getID());
                    if (entryAttr == null || entryAttr.size() != 1) break;
                    this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getID(), null, perms, tuples, entry);
                    break;
                }
                case 2: {
                    perms = REPLACE_PERMS;
                }
            }
            for (int jj = 0; jj < attr.size(); ++jj) {
                this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getID(), attr.get(jj), perms, tuples, entry);
            }
        }
        next.modify(opContext);
        Attributes modifiedEntry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
        this.tupleCache.subentryModified(name, mods, modifiedEntry);
        this.groupCache.groupModified(name, mods, entry);
    }

    @Override
    public boolean hasEntry(NextInterceptor next, EntryOperationContext entryContext) throws NamingException {
        LdapDN name = entryContext.getDn();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled || name.size() == 0) {
            if (name.size() == 0) {
                return true;
            }
            return next.hasEntry(entryContext);
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, BROWSE_PERMS, tuples, entry);
        return next.hasEntry(entryContext);
    }

    private void checkLookupAccess(LdapPrincipal principal, LdapDN dn, Attributes entry) throws NamingException {
        if (dn.toString().trim().equals("")) {
            return;
        }
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN userName = principal.getJndiName();
        Set<LdapDN> userGroups = this.groupCache.getGroups(userName.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, dn, entry);
        this.engine.checkPermission(proxy, userGroups, userName, principal.getAuthenticationLevel(), dn, null, null, LOOKUP_PERMS, tuples, entry);
        NamingEnumeration<? extends Attribute> attributeList = entry.getAll();
        while (attributeList.hasMore()) {
            Attribute attr = attributeList.next();
            for (int ii = 0; ii < attr.size(); ++ii) {
                this.engine.checkPermission(proxy, userGroups, userName, principal.getAuthenticationLevel(), dn, attr.getID(), attr.get(ii), READ_PERMS, tuples, entry);
            }
        }
    }

    @Override
    public Attributes lookup(NextInterceptor next, LookupOperationContext lookupContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!principalDn.isNormalized()) {
            principalDn.normalize(this.attrRegistry.getNormalizerMapping());
        }
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.lookup(lookupContext);
        }
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(lookupContext, PartitionNexusProxy.LOOKUP_BYPASS);
        this.checkLookupAccess(principal, lookupContext.getDn(), entry);
        return next.lookup(lookupContext);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws NamingException {
        LdapDN name = renameContext.getDn();
        String newRdn = renameContext.getNewRdn();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        LdapDN newName = (LdapDN)name.clone();
        newName.remove(name.size() - 1);
        newName.add(this.parseNormalized(newRdn).get(0));
        if (!this.enabled) {
            next.rename(renameContext);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.rename(renameContext);
            this.tupleCache.subentryRenamed((Name)name, (Name)newName);
            this.groupCache.groupRenamed(name, newName);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, RENAME_PERMS, tuples, entry);
        next.rename(renameContext);
        this.tupleCache.subentryRenamed((Name)name, (Name)newName);
        this.groupCache.groupRenamed(name, newName);
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext moveAndRenameContext) throws NamingException {
        LdapDN oriChildName = moveAndRenameContext.getDn();
        LdapDN newParentName = moveAndRenameContext.getParent();
        String newRn = moveAndRenameContext.getNewRdn();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(new LookupOperationContext(oriChildName), PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        LdapDN newName = (LdapDN)newParentName.clone();
        newName.add(newRn);
        if (!this.enabled) {
            next.moveAndRename(moveAndRenameContext);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.moveAndRename(moveAndRenameContext);
            this.tupleCache.subentryRenamed((Name)oriChildName, (Name)newName);
            this.groupCache.groupRenamed(oriChildName, newName);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, tuples, oriChildName, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, oriChildName, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), oriChildName, null, null, MOVERENAME_PERMS, tuples, entry);
        Attributes importedEntry = proxy.lookup(new LookupOperationContext(oriChildName), PartitionNexusProxy.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryService subentryService = (SubentryService)this.chain.get("subentryService");
        Attributes subentryAttrs = subentryService.getSubentryAttributes((Name)newName, importedEntry);
        NamingEnumeration<? extends Attribute> attrList = importedEntry.getAll();
        while (attrList.hasMore()) {
            subentryAttrs.put(attrList.next());
        }
        HashSet<ACITuple> destTuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, destTuples, newName, subentryAttrs);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), newName, null, null, IMPORT_PERMS, destTuples, subentryAttrs);
        next.moveAndRename(moveAndRenameContext);
        this.tupleCache.subentryRenamed((Name)oriChildName, (Name)newName);
        this.groupCache.groupRenamed(oriChildName, newName);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext moveContext) throws NamingException {
        LdapDN oriChildName = moveContext.getDn();
        LdapDN newParentName = moveContext.getParent();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(new LookupOperationContext(oriChildName), PartitionNexusProxy.LOOKUP_BYPASS);
        LdapDN newName = (LdapDN)newParentName.clone();
        newName.add(oriChildName.get(oriChildName.size() - 1));
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.move(moveContext);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.move(moveContext);
            this.tupleCache.subentryRenamed((Name)oriChildName, (Name)newName);
            this.groupCache.groupRenamed(oriChildName, newName);
            return;
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, tuples, oriChildName, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, oriChildName, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), oriChildName, null, null, EXPORT_PERMS, tuples, entry);
        Attributes importedEntry = proxy.lookup(new LookupOperationContext(oriChildName), PartitionNexusProxy.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryService subentryService = (SubentryService)this.chain.get("subentryService");
        Attributes subentryAttrs = subentryService.getSubentryAttributes((Name)newName, importedEntry);
        NamingEnumeration<? extends Attribute> attrList = importedEntry.getAll();
        while (attrList.hasMore()) {
            subentryAttrs.put(attrList.next());
        }
        HashSet<ACITuple> destTuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, destTuples, newName, subentryAttrs);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), newName, null, null, IMPORT_PERMS, destTuples, subentryAttrs);
        next.move(moveContext);
        this.tupleCache.subentryRenamed((Name)oriChildName, (Name)newName);
        this.groupCache.groupRenamed(oriChildName, newName);
    }

    @Override
    public NamingEnumeration<SearchResult> list(NextInterceptor next, ListOperationContext opContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext ctx = (ServerLdapContext)invocation.getCaller();
        LdapPrincipal user = ctx.getPrincipal();
        NamingEnumeration<SearchResult> e = next.list(opContext);
        if (this.isPrincipalAnAdministrator(user.getJndiName()) || !this.enabled) {
            return e;
        }
        AuthorizationFilter authzFilter = new AuthorizationFilter();
        return new SearchResultFilteringEnumeration(e, DEFAULT_SEARCH_CONTROLS, invocation, authzFilter, "List authorization Filter");
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor next, SearchOperationContext opContext) throws NamingException {
        boolean isRootDSELookup;
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext ctx = (ServerLdapContext)invocation.getCaller();
        LdapPrincipal user = ctx.getPrincipal();
        LdapDN principalDn = user.getJndiName();
        NamingEnumeration<SearchResult> e = next.search(opContext);
        boolean isSubschemaSubentryLookup = this.subschemaSubentryDn.equals(opContext.getDn().getNormName());
        SearchControls searchCtls = opContext.getSearchControls();
        boolean bl = isRootDSELookup = opContext.getDn().size() == 0 && searchCtls.getSearchScope() == 0;
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled || isRootDSELookup || isSubschemaSubentryLookup) {
            return e;
        }
        AuthorizationFilter authzFilter = new AuthorizationFilter();
        return new SearchResultFilteringEnumeration(e, searchCtls, invocation, authzFilter, "Search authorization Filter");
    }

    public final boolean isPrincipalAnAdministrator(LdapDN principalDn) throws NamingException {
        return this.groupCache.isPrincipalAnAdministrator(principalDn);
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        String oid = opContext.getOid();
        Object value = opContext.getValue();
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(new LookupOperationContext(name), PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.compare(opContext);
        }
        Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, READ_PERMS, tuples, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, oid, value, COMPARE_PERMS, tuples, entry);
        return next.compare(opContext);
    }

    @Override
    public LdapDN getMatchedName(NextInterceptor next, GetMatchedNameOperationContext opContext) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.getMatchedName(opContext);
        }
        LdapDN matched = next.getMatchedName(opContext);
        while (matched.size() > 0) {
            Attributes entry = proxy.lookup(new LookupOperationContext(matched), PartitionNexusProxy.GETMATCHEDDN_BYPASS);
            Set<LdapDN> userGroups = this.groupCache.getGroups(principalDn.toString());
            HashSet<ACITuple> tuples = new HashSet<ACITuple>();
            this.addPerscriptiveAciTuples(proxy, tuples, matched, entry);
            this.addEntryAciTuples(tuples, entry);
            this.addSubentryAciTuples(proxy, tuples, matched, entry);
            if (this.engine.hasPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), matched, null, null, MATCHEDNAME_PERMS, tuples, entry)) {
                return matched;
            }
            matched.remove(matched.size() - 1);
        }
        return matched;
    }

    public void cacheNewGroup(LdapDN name, Attributes entry) throws NamingException {
        this.groupCache.groupAdded(name, entry);
    }

    private boolean filter(Invocation invocation, LdapDN normName, SearchResult result) throws NamingException {
        Attributes entry = invocation.getProxy().lookup(new LookupOperationContext(normName), PartitionNexusProxy.LOOKUP_BYPASS);
        ServerLdapContext ctx = (ServerLdapContext)invocation.getCaller();
        LdapDN userDn = ctx.getPrincipal().getJndiName();
        Set<LdapDN> userGroups = this.groupCache.getGroups(userDn.toNormName());
        HashSet<ACITuple> tuples = new HashSet<ACITuple>();
        this.addPerscriptiveAciTuples(invocation.getProxy(), tuples, normName, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(invocation.getProxy(), tuples, normName, entry);
        if (!this.engine.hasPermission(invocation.getProxy(), userGroups, userDn, ctx.getPrincipal().getAuthenticationLevel(), normName, null, null, SEARCH_ENTRY_PERMS, tuples, entry)) {
            return false;
        }
        NamingEnumeration<String> idList = result.getAttributes().getIDs();
        while (idList.hasMore()) {
            String id = idList.next();
            Attribute attr = result.getAttributes().get(id);
            if (!this.engine.hasPermission(invocation.getProxy(), userGroups, userDn, ctx.getPrincipal().getAuthenticationLevel(), normName, attr.getID(), null, SEARCH_ATTRVAL_PERMS, tuples, entry)) {
                result.getAttributes().remove(attr.getID());
                if (attr.size() != 0) continue;
                result.getAttributes().remove(attr.getID());
                continue;
            }
            for (int ii = 0; ii < attr.size(); ++ii) {
                if (this.engine.hasPermission(invocation.getProxy(), userGroups, userDn, ctx.getPrincipal().getAuthenticationLevel(), normName, attr.getID(), attr.get(ii), SEARCH_ATTRVAL_PERMS, tuples, entry)) continue;
                attr.remove(ii);
                if (ii <= 0) continue;
                --ii;
            }
        }
        return true;
    }

    static {
        HashSet<MicroOperation> set = new HashSet<MicroOperation>(2);
        set.add(MicroOperation.BROWSE);
        set.add(MicroOperation.RETURN_DN);
        SEARCH_ENTRY_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.READ);
        set.add(MicroOperation.BROWSE);
        LOOKUP_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.ADD);
        set.add(MicroOperation.REMOVE);
        REPLACE_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.EXPORT);
        set.add(MicroOperation.RENAME);
        MOVERENAME_PERMS = Collections.unmodifiableCollection(set);
        SEARCH_ATTRVAL_PERMS = Collections.singleton(MicroOperation.READ);
        ADD_PERMS = Collections.singleton(MicroOperation.ADD);
        READ_PERMS = Collections.singleton(MicroOperation.READ);
        COMPARE_PERMS = Collections.singleton(MicroOperation.COMPARE);
        REMOVE_PERMS = Collections.singleton(MicroOperation.REMOVE);
        MATCHEDNAME_PERMS = Collections.singleton(MicroOperation.DISCLOSE_ON_ERROR);
        BROWSE_PERMS = Collections.singleton(MicroOperation.BROWSE);
        RENAME_PERMS = Collections.singleton(MicroOperation.RENAME);
        EXPORT_PERMS = Collections.singleton(MicroOperation.EXPORT);
        IMPORT_PERMS = Collections.singleton(MicroOperation.IMPORT);
        DEFAULT_SEARCH_CONTROLS = new SearchControls();
    }

    class AuthorizationFilter
    implements SearchResultFilter {
        AuthorizationFilter() {
        }

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            LdapDN normName = AuthorizationService.this.parseNormalized(result.getName());
            return AuthorizationService.this.filter(invocation, normName, result);
        }
    }
}

