/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.trash.TrashInfo;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.edit.lock.LockActions;
import org.nuxeo.ecm.webapp.trashManagement.TrashManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="deleteActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class DeleteActionsBean
extends InputController
implements DeleteActions,
Serializable,
SelectDataModelListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DeleteActionsBean.class);
    public static final String DELETE_OUTCOME = "after_delete";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected RepositoryLocation currentServerLocation;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient TrashManager trashManager;
    @In(create=true)
    protected transient LockActions lockActions;
    @In(create=true)
    protected transient WebActions webActions;
    protected DocumentModelList currentDocumentChildren;
    @In
    protected transient Principal currentUser;
    protected Boolean searchDeletedDocuments;
    protected transient TrashService trashService;
    protected static final int OP_DELETE = 1;
    protected static final int OP_PURGE = 2;
    protected static final int OP_UNDELETE = 3;

    protected TrashService getTrashService() {
        if (this.trashService == null) {
            try {
                this.trashService = (TrashService)Framework.getService(TrashService.class);
            }
            catch (Exception e) {
                throw new RuntimeException("TrashService not available", e);
            }
        }
        return this.trashService;
    }

    @Override
    public boolean getCanDeleteItem(DocumentModel container) throws ClientException {
        if (container == null) {
            return false;
        }
        return this.getTrashService().folderAllowsDelete(container);
    }

    @Override
    public boolean getCanDelete() {
        return this.getCanDelete("CURRENT_SELECTION");
    }

    @Override
    public boolean getCanDelete(String listName) {
        List docs = this.documentsListsManager.getWorkingList(listName);
        try {
            return this.getTrashService().canDelete(docs, this.currentUser, false);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean getCanDeleteSections() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        try {
            return this.getTrashService().canDelete(docs, this.currentUser, true);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean getCanPurge() throws ClientException {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH");
        try {
            return this.getTrashService().canPurgeOrUndelete(docs, this.currentUser);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean checkDeletePermOnParents(List<DocumentModel> docs) {
        try {
            return this.getTrashService().checkDeletePermOnParents(docs);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    @Override
    public String deleteSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return this.deleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String deleteSelectionSections() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_SECTIONS")) {
            return this.deleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String deleteSelection(List<DocumentModel> docs) throws ClientException {
        int op = this.isTrashManagementEnabled() ? 1 : 2;
        return this.actOnSelection(op, docs);
    }

    @Override
    public String purgeSelection() throws ClientException {
        return this.purgeSelection("CURRENT_SELECTION_TRASH");
    }

    @Override
    public String purgeSelection(String listName) throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty(listName)) {
            return this.purgeSelection(this.documentsListsManager.getWorkingList(listName));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String purgeSelection(List<DocumentModel> docs) throws ClientException {
        return this.actOnSelection(2, docs);
    }

    @Override
    public String undeleteSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_TRASH")) {
            return this.undeleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String undeleteSelection(List<DocumentModel> docs) throws ClientException {
        return this.actOnSelection(3, docs);
    }

    protected String actOnSelection(int op, List<DocumentModel> docs) throws ClientException {
        String msgid;
        Set parentRefs;
        TrashInfo info;
        if (docs == null) {
            return null;
        }
        try {
            info = this.getTrashService().getTrashInfo(docs, this.currentUser, false, false);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return null;
        }
        DocumentModel targetContext = this.getTrashService().getAboveDocument(this.navigationContext.getCurrentDocument(), info.rootPaths);
        this.documentsListsManager.removeFromAllLists(info.docs);
        switch (op) {
            case 2: {
                this.getTrashService().purgeDocuments(this.documentManager, info.rootRefs);
                parentRefs = info.rootParentRefs;
                msgid = "n_deleted_docs";
                break;
            }
            case 1: {
                this.getTrashService().trashDocuments(info.docs);
                parentRefs = info.rootParentRefs;
                msgid = "n_deleted_docs";
                break;
            }
            case 3: {
                parentRefs = this.getTrashService().undeleteDocuments(info.docs);
                msgid = "n_undeleted_docs";
                break;
            }
            default: {
                throw new AssertionError(op);
            }
        }
        this.navigationContext.setCurrentDocument(targetContext);
        if (parentRefs.isEmpty()) {
            Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
        } else {
            for (DocumentRef parentRef : parentRefs) {
                DocumentModel parent = this.documentManager.getDocument(parentRef);
                if (parent == null) continue;
                Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parent});
            }
        }
        if (info.proxies > 0) {
            this.facesMessages.add(StatusMessage.Severity.WARN, "can_not_delete_proxies", new Object[0]);
        }
        Object[] params = new Object[]{info.docs.size()};
        this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + (String)this.resourcesAccessor.getMessages().get(msgid), params);
        return this.computeOutcome(DELETE_OUTCOME);
    }

    @Override
    public boolean isTrashManagementEnabled() {
        return this.trashManager.isTrashManagementEnabled();
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION_TRASH", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION_TRASH", data);
        }
    }

    public List<Action> getActionsForTrashSelection() {
        return this.webActions.getUnfiltredActionsList("CURRENT_SELECTION_TRASH_LIST");
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void restoreCurrentDocument() throws ClientException {
        ArrayList<DocumentModel> doc = new ArrayList<DocumentModel>();
        doc.add(this.navigationContext.getCurrentDocument());
        this.undeleteSelection(doc);
    }

    @Override
    public boolean getCanRestoreCurrentDoc() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null) {
            log.warn((Object)"Null currentDocument in navigationContext");
            return false;
        }
        try {
            return this.getTrashService().canPurgeOrUndelete(Collections.singletonList(doc), this.currentUser);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot check delete permission", (Throwable)e);
            return false;
        }
    }

    public boolean restoreActionDisplay() throws ClientException {
        return this.getCanRestoreCurrentDoc() && this.isTrashManagementEnabled();
    }
}

