/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import java.util.HashMap;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;

@Operation(id="Workflow.CompleteTaskOperation", category="Workflow Context", label="Complete task", requires="Workflow", description="Completes the input task. If this is the last task the workflow will continue. Returns back the task document. \"Status\" is the id of the button the user would have clicked to submit the task form (if the outgoing transitions of the workflow node that created the task have conditions depending on it).@since 5.9.3 and 5.8.0-HF11 you can set multiple  node or workflow variables when completing the task (also similar to ending the task via form submision from the UI).The variables are specified as <i>key=value</i> pairs separated by a new line.To specify multi-line values you can use a \\ character followed by a new line. <p>Example:<pre>description=foo bar</pre>For updating a date, you will need to expose the value as ISO 8601 format, for instance : <p>Example:<pre>workflowVarString=A sample value<br>workflowVarDate=@{org.nuxeo.ecm.core.schema.utils.DateParser.formatW3CDateTime(CurrentDate.date)}</pre><p>For all values, you have to submit a JSON representation. This is an example for a variable of type StringList:<p><pre>nodeVarList = [\"John Doe\", \"John Test\"]</pre></p>")
public class CompleteTaskOperation {
    public static final String ID = "Workflow.CompleteTaskOperation";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="status", required=false)
    protected String status;
    @Param(name="comment", required=false)
    protected String comment;
    @Param(name="nodeVariables", required=false)
    protected Properties nodeVariables;
    @Param(name="workflowVariables", required=false)
    protected Properties workflowVariables;
    @Context
    protected DocumentRoutingService documentRoutingService;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel completeTask(DocumentModel task) throws ClientException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.comment != null) {
            data.put("comment", this.comment);
        }
        if (this.nodeVariables != null) {
            data.put("NodeVariables", this.nodeVariables);
        }
        if (this.workflowVariables != null) {
            data.put("WorkflowVariables", this.workflowVariables);
        }
        data.put("_MAP_VAR_FORMAT_JSON", Boolean.TRUE);
        this.documentRoutingService.endTask(this.session, (Task)task.getAdapter(Task.class), data, this.status);
        return task;
    }
}

