/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.redis;

import java.io.IOException;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.redis.RedisWorkQueuing;

public class RedisBlockingQueue
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable> {
    private static final Log log = LogFactory.getLog(RedisBlockingQueue.class);
    protected final String queueId;
    protected final RedisWorkQueuing queuing;

    public RedisBlockingQueue(String queueId, RedisWorkQueuing queuing) {
        this.queueId = queueId;
        this.queuing = queuing;
    }

    @Override
    public boolean offer(Runnable r) {
        Work work = WorkHolder.getWork(r);
        try {
            this.queuing.addScheduledWork(this.queueId, work);
            return true;
        }
        catch (IOException e) {
            log.error((Object)("Failed to add Work: " + work), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean offer(Runnable r, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(r);
    }

    @Override
    public void put(Runnable r) throws InterruptedException {
        this.offer(r);
    }

    @Override
    public Runnable peek() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Runnable take() throws InterruptedException {
        Runnable r;
        while ((r = this.poll(1L, TimeUnit.DAYS)) == null) {
        }
        return r;
    }

    @Override
    public Runnable poll() {
        Work work = this.queuing.removeScheduled(this.queueId);
        return work == null ? null : new WorkHolder(work);
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        long expiry = System.currentTimeMillis() + unit.toMillis(timeout);
        Runnable r;
        while ((r = this.poll()) == null) {
            if (System.currentTimeMillis() >= expiry) {
                return null;
            }
            Thread.sleep(100L);
        }
        return r;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.queuing.getScheduledSize(this.queueId);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Iterator<Runnable> iterator() {
        return new Iter();
    }

    @Override
    public int drainTo(Collection<? super Runnable> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            Runnable r = this.poll();
            if (r == null) {
                return i;
            }
            c.add(r);
        }
        return maxElements;
    }

    private class Iter
    implements Iterator<Runnable> {
        public Iter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Runnable next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

