/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.model.DocumentContainer;
import org.nuxeo.ecm.core.model.Lockable;
import org.nuxeo.ecm.core.model.PropertyContainer;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.versioning.VersionableDocument;

public interface Document
extends DocumentContainer,
PropertyContainer,
VersionableDocument,
Lockable {
    public Session getSession();

    public String getName() throws DocumentException;

    public String getUUID();

    public Document getParent() throws DocumentException;

    public DocumentType getType();

    public String getPath() throws DocumentException;

    public Calendar getLastModified() throws DocumentException;

    public boolean isFolder();

    public void setReadOnly(boolean var1);

    public boolean isReadOnly();

    public void remove() throws DocumentException;

    public void save() throws DocumentException;

    public String getLifeCycleState() throws LifeCycleException;

    public void setCurrentLifeCycleState(String var1) throws LifeCycleException;

    public String getLifeCyclePolicy() throws LifeCycleException;

    public void setLifeCyclePolicy(String var1) throws LifeCycleException;

    public boolean followTransition(String var1) throws LifeCycleException;

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException;

    public boolean isProxy();

    public Repository getRepository();

    public <T extends Serializable> void setSystemProp(String var1, T var2) throws DocumentException;

    public <T extends Serializable> T getSystemProp(String var1, Class<T> var2) throws DocumentException;

    public void readDocumentPart(DocumentPart var1) throws Exception;

    public void writeDocumentPart(DocumentPart var1) throws Exception;

    public Set<String> getAllFacets();

    public String[] getFacets();

    public boolean hasFacet(String var1);

    public boolean addFacet(String var1) throws DocumentException;

    public boolean removeFacet(String var1) throws DocumentException;
}

