/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSExpressionMathMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionMemberMathProduct
implements ICSSExpressionMathMember {
    private final List<ICSSExpressionMathMember> m_aMembers = new ArrayList<ICSSExpressionMathMember>();

    public void addMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        if (iCSSExpressionMathMember == null) {
            throw new NullPointerException("member");
        }
        this.m_aMembers.add(iCSSExpressionMathMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSExpressionMathMember iCSSExpressionMathMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(iCSSExpressionMathMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSExpressionMathMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSExpressionMathMember iCSSExpressionMathMember : this.m_aMembers) {
            stringBuilder.append(iCSSExpressionMathMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSExpressionMemberMathProduct)) {
            return false;
        }
        CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = (CSSExpressionMemberMathProduct)object;
        return ((Object)this.m_aMembers).equals(cSSExpressionMemberMathProduct.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).toString();
    }
}

