/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;

public abstract class XWPFHeaderFooter {
    protected CTHdrFtr headerFooter;

    protected XWPFHeaderFooter(CTHdrFtr hdrFtr) {
        this.headerFooter = hdrFtr;
    }

    protected XWPFHeaderFooter() {
        this.headerFooter = CTHdrFtr.Factory.newInstance();
    }

    public CTHdrFtr _getHdrFtr() {
        return this.headerFooter;
    }

    public XWPFParagraph[] getParagraphs() {
        XWPFParagraph[] paras = new XWPFParagraph[this.headerFooter.getPArray().length];
        for (int i = 0; i < paras.length; ++i) {
            paras[i] = new XWPFParagraph(this.headerFooter.getPArray(i), null);
        }
        return paras;
    }

    public XWPFTable[] getTables() {
        XWPFTable[] tables = new XWPFTable[this.headerFooter.getTblArray().length];
        for (int i = 0; i < tables.length; ++i) {
            tables[i] = new XWPFTable(this.headerFooter.getTblArray(i));
        }
        return tables;
    }

    public String getText() {
        StringBuffer t = new StringBuffer();
        XWPFParagraph[] paras = this.getParagraphs();
        for (int i = 0; i < paras.length; ++i) {
            String text;
            if (paras[i].isEmpty() || (text = paras[i].getText()) == null || text.length() <= 0) continue;
            t.append(text);
            t.append('\n');
        }
        XWPFTable[] tables = this.getTables();
        for (int i = 0; i < tables.length; ++i) {
            String text = tables[i].getText();
            if (text == null || text.length() <= 0) continue;
            t.append(text);
            t.append('\n');
        }
        return t.toString();
    }
}

