/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BaseProperty;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.CollectionProperty;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.FragmentGroup;
import org.nuxeo.ecm.core.storage.sql.FragmentsMap;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;

public class Node {
    private final PersistenceContext context;
    private final Model model;
    protected final SimpleFragment hierFragment;
    protected final FragmentsMap fragments;
    protected String path;
    private final Map<String, BaseProperty> propertyCache;
    private Boolean isVersion;
    private static final String[] NO_MIXINS = new String[0];

    protected Node(PersistenceContext context, FragmentGroup fragmentGroup, String path) throws StorageException {
        this.context = context;
        this.model = context.model;
        this.hierFragment = fragmentGroup.hier;
        this.fragments = fragmentGroup.fragments == null ? new FragmentsMap() : fragmentGroup.fragments;
        this.path = path;
        this.propertyCache = new ReferenceMap(0, 1);
    }

    public Serializable getId() {
        return this.hierFragment.getId();
    }

    public String getName() {
        try {
            return this.getHierFragment().getString("name");
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public String getPrimaryType() {
        try {
            return this.hierFragment.getString("primarytype");
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Serializable getParentId() {
        try {
            return this.getHierFragment().get("parentid");
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public String getPath() {
        String p = this.path;
        if (p != null) {
            this.path = null;
        }
        return p;
    }

    protected SimpleFragment getHierFragment() {
        return this.hierFragment;
    }

    public boolean isVersion() {
        if (this.isVersion == null) {
            try {
                this.isVersion = (Boolean)this.getSimpleProperty("ecm:isVersion").getValue();
            }
            catch (StorageException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
            if (this.isVersion == null) {
                this.isVersion = Boolean.FALSE;
            }
        }
        return this.isVersion;
    }

    public boolean isProxy() {
        String primaryType = this.getPrimaryType();
        if (primaryType == null) {
            throw new NullPointerException(this.toString());
        }
        return primaryType.equals("ecm:proxy");
    }

    public String[] getMixinTypes() {
        try {
            String[] value = (String[])this.hierFragment.get("mixintypes");
            return value == null ? NO_MIXINS : (String[])value.clone();
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public Set<String> getAllMixinTypes() {
        LinkedHashSet<String> mixins = new LinkedHashSet<String>(this.model.getDocumentTypeFacets(this.getPrimaryType()));
        mixins.addAll(Arrays.asList(this.getMixinTypes()));
        return mixins;
    }

    public boolean hasMixinType(String mixin) {
        if (this.model.getDocumentTypeFacets(this.getPrimaryType()).contains(mixin)) {
            return true;
        }
        for (String m : this.getMixinTypes()) {
            if (!m.equals(mixin)) continue;
            return true;
        }
        return false;
    }

    protected void clearCache() {
        this.propertyCache.clear();
    }

    public SimpleProperty getSimpleProperty(String name) throws StorageException {
        SimpleProperty property = (SimpleProperty)this.propertyCache.get(name);
        if (property == null) {
            ModelProperty propertyInfo = this.getPropertyInfo(name);
            if (propertyInfo == null) {
                throw new IllegalArgumentException("Unknown field: " + name);
            }
            property = this.makeSimpleProperty(name, propertyInfo);
            this.propertyCache.put(name, property);
        }
        return property;
    }

    protected SimpleProperty makeSimpleProperty(String name, ModelProperty propertyInfo) throws StorageException {
        String fragmentName = propertyInfo.fragmentName;
        Fragment fragment = (Fragment)this.fragments.get(fragmentName);
        if (fragment == null) {
            RowId rowId = new RowId(fragmentName, this.getId());
            fragment = this.context.get(rowId, true);
            this.fragments.put(fragmentName, fragment);
        }
        return new SimpleProperty(name, propertyInfo.propertyType, propertyInfo.readonly, (SimpleFragment)fragment, propertyInfo.fragmentKey);
    }

    public CollectionProperty getCollectionProperty(String name) throws StorageException {
        CollectionProperty property = (CollectionProperty)this.propertyCache.get(name);
        if (property == null) {
            ModelProperty propertyInfo = this.getPropertyInfo(name);
            if (propertyInfo == null) {
                throw new IllegalArgumentException("Unknown field: " + name);
            }
            property = this.makeCollectionProperty(name, propertyInfo);
            this.propertyCache.put(name, property);
        }
        return property;
    }

    protected CollectionProperty makeCollectionProperty(String name, ModelProperty propertyInfo) throws StorageException {
        String fragmentName = propertyInfo.fragmentName;
        Fragment fragment = (Fragment)this.fragments.get(fragmentName);
        if (fragment == null) {
            RowId rowId = new RowId(fragmentName, this.getId());
            fragment = this.context.get(rowId, true);
        }
        if (fragment instanceof CollectionFragment) {
            return new CollectionProperty(name, propertyInfo.propertyType, propertyInfo.readonly, (CollectionFragment)fragment);
        }
        this.fragments.put(fragmentName, fragment);
        return new CollectionProperty(name, propertyInfo.propertyType, propertyInfo.readonly, (SimpleFragment)fragment, propertyInfo.fragmentKey);
    }

    public BaseProperty getProperty(String name) throws StorageException {
        BaseProperty property = this.propertyCache.get(name);
        if (property != null) {
            return property;
        }
        ModelProperty propertyInfo = this.getPropertyInfo(name);
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Unknown field: " + name);
        }
        if (propertyInfo.propertyType.isArray()) {
            return this.getCollectionProperty(name);
        }
        return this.getSimpleProperty(name);
    }

    protected ModelProperty getPropertyInfo(String name) {
        ModelProperty propertyInfo = this.model.getPropertyInfo(this.getPrimaryType(), name);
        if (propertyInfo != null) {
            return propertyInfo;
        }
        for (String mixin : this.getMixinTypes()) {
            propertyInfo = this.model.getMixinPropertyInfo(mixin, name);
            if (propertyInfo == null) continue;
            return propertyInfo;
        }
        if (this.isProxy() && (propertyInfo = this.model.getProxySchemasPropertyInfo(name)) != null) {
            return propertyInfo;
        }
        return null;
    }

    public void setSimpleProperty(String name, Serializable value) throws StorageException {
        SimpleProperty property = this.getSimpleProperty(name);
        property.setValue(value);
    }

    public void setCollectionProperty(String name, Serializable[] value) throws StorageException {
        CollectionProperty property = this.getCollectionProperty(name);
        property.setValue(value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Node) {
            return this.equals((Node)other);
        }
        return false;
    }

    private boolean equals(Node other) {
        return this.getId() == other.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(uuid=" + this.getId() + ", name=" + this.getName() + ", primaryType=" + this.getPrimaryType() + ", parentId=" + this.getParentId() + ")";
    }
}

