/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

public class Selection {
    private static final Log log = LogFactory.getLog(Selection.class);
    private final Serializable selId;
    private final String tableName;
    protected final PersistenceContext context;
    protected final String filterKey;
    private final Map<Serializable, Selection> softMap;
    private final Map<Serializable, Selection> hardMap;
    protected boolean complete;
    protected Set<Serializable> existing;
    protected Set<Serializable> created;
    protected Set<Serializable> deleted;

    public Selection(Serializable selId, String tableName, boolean empty, String filterKey, PersistenceContext context, Map<Serializable, Selection> softMap, Map<Serializable, Selection> hardMap) {
        this.selId = selId;
        this.tableName = tableName;
        this.context = context;
        this.filterKey = filterKey;
        this.softMap = softMap;
        this.hardMap = hardMap;
        this.complete = empty;
        softMap.put(selId, this);
    }

    protected Serializable fragmentValue(SimpleFragment fragment) {
        try {
            return fragment.get(this.filterKey);
        }
        catch (StorageException e) {
            log.error((Object)("Could not fetch value: " + fragment.getId()));
            return null;
        }
    }

    public void addExisting(Serializable id) {
        if (this.existing == null) {
            this.existing = new HashSet<Serializable>();
        }
        if (this.existing.contains(id) || this.created != null && this.created.contains(id)) {
            return;
        }
        this.existing.add(id);
    }

    public void addCreated(Serializable id) {
        if (this.created == null) {
            this.created = new HashSet<Serializable>();
            this.softMap.remove(this.selId);
            this.hardMap.put(this.selId, this);
        }
        if (this.existing != null && this.existing.contains(id) || this.created.contains(id)) {
            log.error((Object)("Creating already present id: " + id));
            return;
        }
        this.created.add(id);
    }

    public void addExistingComplete(List<Serializable> actualExisting) {
        assert (!this.complete);
        this.complete = true;
        this.existing = new HashSet<Serializable>(actualExisting);
    }

    public void setIncomplete() {
        this.complete = false;
    }

    public void remove(Serializable id) {
        if (this.created != null && this.created.remove(id)) {
            return;
        }
        if (this.existing != null) {
            this.existing.remove(id);
        }
        if (this.deleted == null) {
            this.deleted = new HashSet<Serializable>();
            this.softMap.remove(this.selId);
            this.hardMap.put(this.selId, this);
        }
        this.deleted.add(id);
    }

    public void flush() {
        if (this.created != null) {
            if (this.existing == null) {
                this.existing = new HashSet<Serializable>();
            }
            this.existing.addAll(this.created);
            this.created = null;
        }
        this.deleted = null;
        this.softMap.put(this.selId, this);
    }

    public boolean isFlushed() {
        return this.created == null && this.deleted == null;
    }

    private SimpleFragment getFragmentIfPresent(Serializable id) {
        RowId rowId = new RowId(this.tableName, id);
        return (SimpleFragment)this.context.getIfPresent(rowId);
    }

    private SimpleFragment getFragment(Serializable id) throws StorageException {
        RowId rowId = new RowId(this.tableName, id);
        return (SimpleFragment)this.context.get(rowId, false);
    }

    public SimpleFragment getFragmentByValue(Serializable filter) {
        SimpleFragment fragment;
        if (this.existing != null) {
            for (Serializable id : this.existing) {
                try {
                    fragment = this.getFragment(id);
                }
                catch (StorageException e) {
                    log.warn((Object)("Failed refetch for: " + id), (Throwable)((Object)e));
                    continue;
                }
                if (fragment == null) {
                    log.warn((Object)("Existing fragment missing: " + id));
                    continue;
                }
                if (!filter.equals(this.fragmentValue(fragment))) continue;
                return fragment;
            }
        }
        if (this.created != null) {
            for (Serializable id : this.created) {
                fragment = this.getFragmentIfPresent(id);
                if (fragment == null) {
                    log.warn((Object)("Created fragment missing: " + id));
                    continue;
                }
                if (!filter.equals(this.fragmentValue(fragment))) continue;
                return fragment;
            }
        }
        if (this.deleted != null) {
            for (Serializable id : this.deleted) {
                fragment = this.getFragmentIfPresent(id);
                if (fragment == null || !filter.equals(this.fragmentValue(fragment))) continue;
                return null;
            }
        }
        return this.complete ? null : SimpleFragment.UNKNOWN;
    }

    public List<SimpleFragment> getFragmentsByValue(Serializable filter) {
        SimpleFragment fragment;
        if (!this.complete) {
            return null;
        }
        LinkedList<SimpleFragment> filtered = new LinkedList<SimpleFragment>();
        if (this.existing != null) {
            for (Serializable id : this.existing) {
                try {
                    fragment = this.getFragment(id);
                }
                catch (StorageException e) {
                    log.warn((Object)("Failed refetch for: " + id), (Throwable)((Object)e));
                    continue;
                }
                if (fragment == null) {
                    log.warn((Object)("Existing fragment missing: " + id));
                    continue;
                }
                if (filter != null && !filter.equals(this.fragmentValue(fragment))) continue;
                filtered.add(fragment);
            }
        }
        if (this.created != null) {
            for (Serializable id : this.created) {
                fragment = this.getFragmentIfPresent(id);
                if (fragment == null) {
                    log.warn((Object)("Created fragment missing: " + id));
                    continue;
                }
                if (filter != null && !filter.equals(this.fragmentValue(fragment))) continue;
                filtered.add(fragment);
            }
        }
        return filtered;
    }
}

