/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.runtime.metrics.MetricsService;

public class DirectoryCache {
    private static final Log log = LogFactory.getLog(DirectoryCache.class);
    protected final String name;
    protected final Map<String, CachedEntry> entryStore = new HashMap<String, CachedEntry>();
    protected final Map<String, CachedEntry> entryStoreWithoutReferences = new HashMap<String, CachedEntry>();
    protected final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter hitsCounter;
    protected final Counter invalidationsCounter;
    protected final Counter maxCounter;
    protected final Counter sizeCounter;
    protected int timeout = 0;
    protected int maxSize = 0;

    protected DirectoryCache(String name) {
        this.name = name;
        this.hitsCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "hits"}));
        this.invalidationsCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "invalidations"}));
        this.sizeCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "size"}));
        this.maxCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "max"}));
    }

    protected boolean isCacheEnabled() {
        return this.maxSize > 0;
    }

    public DocumentModel getEntry(String entryId, EntrySource source) throws DirectoryException {
        return this.getEntry(entryId, source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel getEntry(String entryId, EntrySource source, boolean fetchReferences) throws DirectoryException {
        DocumentModel dm;
        CachedEntry entry;
        if (!this.isCacheEnabled()) {
            return source.getEntryFromSource(entryId, fetchReferences);
        }
        if (fetchReferences) {
            entry = this.entryStore.get(entryId);
            if (entry == null || entry.isExpired()) {
                dm = source.getEntryFromSource(entryId, fetchReferences);
                DirectoryCache directoryCache = this;
                synchronized (directoryCache) {
                    if (this.maxSize > 0 && this.entryStore.size() >= this.maxSize) {
                        log.warn((Object)("Directory cacheMaxSize for " + this.name + " is too small, flushing."));
                        this.entryStore.clear();
                    }
                    this.entryStore.put(entryId, new CachedEntry(dm, this.timeout));
                    this.sizeCounter.inc();
                    if (this.sizeCounter.getCount() > this.maxCounter.getCount()) {
                        this.maxCounter.inc();
                    }
                }
            } else {
                dm = entry.getDocumentModel();
                this.hitsCounter.inc();
            }
        } else {
            entry = this.entryStoreWithoutReferences.get(entryId);
            if (entry == null || entry.isExpired()) {
                dm = source.getEntryFromSource(entryId, fetchReferences);
                DirectoryCache directoryCache = this;
                synchronized (directoryCache) {
                    if (this.maxSize > 0 && this.entryStoreWithoutReferences.size() >= this.maxSize) {
                        this.entryStoreWithoutReferences.clear();
                    }
                    this.entryStoreWithoutReferences.put(entryId, new CachedEntry(dm, this.timeout));
                    this.sizeCounter.inc();
                    if (this.sizeCounter.getCount() > this.maxCounter.getCount()) {
                        this.maxCounter.inc();
                    }
                }
            } else {
                dm = entry.getDocumentModel();
                this.hitsCounter.inc();
            }
        }
        try {
            if (dm == null) {
                return null;
            }
            DocumentModel clone = dm.clone();
            if (BaseSession.isReadOnlyEntry(dm)) {
                BaseSession.setReadOnlyEntry(clone);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return dm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(List<String> entryIds) {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                for (String entryId : entryIds) {
                    this.entryStore.remove(entryId);
                    this.entryStoreWithoutReferences.remove(entryId);
                    this.sizeCounter.dec();
                    this.invalidationsCounter.inc();
                }
            }
        }
    }

    public void invalidate(String ... entryIds) {
        this.invalidate(Arrays.asList(entryIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                long count = this.sizeCounter.getCount();
                this.sizeCounter.dec(count);
                this.invalidationsCounter.inc(count);
                this.entryStore.clear();
                this.entryStoreWithoutReferences.clear();
            }
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    protected static class CachedEntry {
        protected final DocumentModel entry;
        protected final Calendar expirationDate;

        CachedEntry(DocumentModel entry, int timeout) {
            this.entry = entry;
            this.expirationDate = Calendar.getInstance();
            this.expirationDate.add(13, timeout);
        }

        public DocumentModel getDocumentModel() {
            return this.entry;
        }

        public boolean isExpired() {
            return this.expirationDate.before(Calendar.getInstance());
        }
    }
}

