/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DetachedAdapter;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentModelsChunk;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NoRollbackOnException;
import org.nuxeo.ecm.core.api.SerializableInputStream;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocsQueryProviderDef;
import org.nuxeo.ecm.core.api.operation.Operation;
import org.nuxeo.ecm.core.api.operation.ProgressMonitor;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.Schema;

public interface CoreSession {
    public static final String IMPORT_VERSION_VERSIONABLE_ID = "ecm:versionableId";
    public static final String IMPORT_VERSION_CREATED = "ecm:versionCreated";
    public static final String IMPORT_VERSION_LABEL = "ecm:versionLabel";
    public static final String IMPORT_VERSION_DESCRIPTION = "ecm:versionDescription";
    public static final String IMPORT_VERSION_IS_LATEST = "ecm:isLatestVersion";
    public static final String IMPORT_VERSION_IS_LATEST_MAJOR = "ecm:isLatestMajorVersion";
    public static final String IMPORT_IS_VERSION = "ecm:isVersion";
    public static final String IMPORT_VERSION_MAJOR = "ecm:majorVersion";
    public static final String IMPORT_VERSION_MINOR = "ecm:minorVersion";
    public static final String IMPORT_PROXY_TARGET_ID = "ecm:proxyTargetId";
    public static final String IMPORT_PROXY_VERSIONABLE_ID = "ecm:proxyVersionableId";
    public static final String IMPORT_LIFECYCLE_POLICY = "ecm:lifeCyclePolicy";
    public static final String IMPORT_LIFECYCLE_STATE = "ecm:lifeCycleState";
    @Deprecated
    public static final String IMPORT_LOCK = "ecm:lock";
    public static final String IMPORT_LOCK_OWNER = "ecm:lockOwner";
    public static final String IMPORT_LOCK_CREATED = "ecm:lockCreated";
    public static final String IMPORT_CHECKED_IN = "ecm:isCheckedIn";
    public static final String IMPORT_BASE_VERSION_ID = "ecm:baseVersionId";
    public static final String IMPORT_PROXY_TYPE = "ecm:proxy";
    public static final String ALLOW_VERSION_WRITE = "allowVersionWrite";

    public void afterBegin();

    public void beforeCompletion();

    public void afterCompletion(boolean var1);

    public DocumentType getDocumentType(String var1);

    public String connect(String var1, Map<String, Serializable> var2) throws ClientException;

    public void disconnect() throws ClientException;

    public void cancel() throws ClientException;

    public void save() throws ClientException;

    public String getSessionId();

    public boolean isStateSharedByAllThreadSessions();

    public Principal getPrincipal();

    public boolean hasPermission(DocumentRef var1, String var2) throws ClientException;

    public boolean hasPermission(Principal var1, DocumentRef var2, String var3) throws ClientException;

    public DocumentModel getRootDocument() throws ClientException;

    @NoRollbackOnException
    public DocumentModel getDocument(DocumentRef var1) throws ClientException;

    @NoRollbackOnException
    public DocumentModelList getDocuments(DocumentRef[] var1) throws ClientException;

    public DocumentModel getChild(DocumentRef var1, String var2) throws ClientException;

    @NoRollbackOnException
    public DocumentModelList getChildren(DocumentRef var1) throws ClientException;

    public DocumentModelIterator getChildrenIterator(DocumentRef var1) throws ClientException;

    @NoRollbackOnException
    public DocumentModelList getChildren(DocumentRef var1, String var2) throws ClientException;

    @Deprecated
    public DocumentModelIterator getChildrenIterator(DocumentRef var1, String var2) throws ClientException;

    @NoRollbackOnException
    public DocumentModelList getChildren(DocumentRef var1, String var2, String var3) throws ClientException;

    @NoRollbackOnException
    public DocumentModelList getChildren(DocumentRef var1, String var2, String var3, Filter var4, Sorter var5) throws ClientException;

    public List<DocumentRef> getChildrenRefs(DocumentRef var1, String var2) throws ClientException;

    public DocumentModelsChunk getDocsResultChunk(DocsQueryProviderDef var1, String var2, String var3, Filter var4, int var5, int var6) throws ClientException;

    public DocumentModelIterator getChildrenIterator(DocumentRef var1, String var2, String var3, Filter var4) throws ClientException;

    public DocumentModelList getChildren(DocumentRef var1, String var2, Filter var3, Sorter var4) throws ClientException;

    public DocumentModelList getFolders(DocumentRef var1) throws ClientException;

    @Deprecated
    public DocumentModelIterator getFoldersIterator(DocumentRef var1) throws ClientException;

    public DocumentModelList getFolders(DocumentRef var1, Filter var2, Sorter var3) throws ClientException;

    public DocumentModelList getFiles(DocumentRef var1) throws ClientException;

    @Deprecated
    public DocumentModelIterator getFilesIterator(DocumentRef var1) throws ClientException;

    public DocumentModelList getFiles(DocumentRef var1, Filter var2, Sorter var3) throws ClientException;

    public DocumentRef getParentDocumentRef(DocumentRef var1) throws ClientException;

    @NoRollbackOnException
    public DocumentModel getParentDocument(DocumentRef var1) throws ClientException;

    public List<DocumentModel> getParentDocuments(DocumentRef var1) throws ClientException;

    public boolean exists(DocumentRef var1) throws ClientException;

    public boolean hasChildren(DocumentRef var1) throws ClientException;

    public DocumentModel createDocumentModel(String var1) throws ClientException;

    public DocumentModel createDocumentModel(String var1, String var2, String var3) throws ClientException;

    public DocumentModel createDocumentModel(String var1, Map<String, Object> var2) throws ClientException;

    public DocumentModel createDocument(DocumentModel var1) throws ClientException;

    public DocumentModel[] createDocument(DocumentModel[] var1) throws ClientException;

    public void importDocuments(List<DocumentModel> var1) throws ClientException;

    public DocumentModel saveDocument(DocumentModel var1) throws ClientException;

    public void saveDocuments(DocumentModel[] var1) throws ClientException;

    public boolean canRemoveDocument(DocumentRef var1) throws ClientException;

    public void removeDocument(DocumentRef var1) throws ClientException;

    public void removeDocuments(DocumentRef[] var1) throws ClientException;

    public void removeChildren(DocumentRef var1) throws ClientException;

    public DocumentModel copy(DocumentRef var1, DocumentRef var2, String var3) throws ClientException;

    public DocumentModel copy(DocumentRef var1, DocumentRef var2, String var3, boolean var4) throws ClientException;

    public List<DocumentModel> copy(List<DocumentRef> var1, DocumentRef var2) throws ClientException;

    public List<DocumentModel> copy(List<DocumentRef> var1, DocumentRef var2, boolean var3) throws ClientException;

    public DocumentModel copyProxyAsDocument(DocumentRef var1, DocumentRef var2, String var3) throws ClientException;

    public DocumentModel copyProxyAsDocument(DocumentRef var1, DocumentRef var2, String var3, boolean var4) throws ClientException;

    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> var1, DocumentRef var2) throws ClientException;

    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> var1, DocumentRef var2, boolean var3) throws ClientException;

    public DocumentModel move(DocumentRef var1, DocumentRef var2, String var3) throws ClientException;

    public void move(List<DocumentRef> var1, DocumentRef var2) throws ClientException;

    public ACP getACP(DocumentRef var1) throws ClientException;

    public void setACP(DocumentRef var1, ACP var2, boolean var3) throws ClientException;

    public DataModel getDataModel(DocumentRef var1, Schema var2) throws ClientException;

    public SerializableInputStream getContentData(String var1) throws ClientException;

    public String getStreamURI(String var1) throws ClientException;

    @Deprecated
    public VersionModel getLastVersion(DocumentRef var1) throws ClientException;

    public DocumentModel getLastDocumentVersion(DocumentRef var1) throws ClientException;

    public DocumentRef getLastDocumentVersionRef(DocumentRef var1) throws ClientException;

    public DocumentModel getSourceDocument(DocumentRef var1) throws ClientException;

    public List<DocumentRef> getVersionsRefs(DocumentRef var1) throws ClientException;

    public List<DocumentModel> getVersions(DocumentRef var1) throws ClientException;

    public List<VersionModel> getVersionsForDocument(DocumentRef var1) throws ClientException;

    @Deprecated
    public DocumentModel getVersion(String var1, VersionModel var2) throws ClientException;

    public String getVersionLabel(DocumentModel var1) throws ClientException;

    public DocumentModel getDocumentWithVersion(DocumentRef var1, VersionModel var2) throws ClientException;

    public DocumentModel restoreToVersion(DocumentRef var1, DocumentRef var2, boolean var3, boolean var4) throws ClientException;

    @Deprecated
    public DocumentModel restoreToVersion(DocumentRef var1, VersionModel var2, boolean var3) throws ClientException;

    public DocumentModel restoreToVersion(DocumentRef var1, DocumentRef var2) throws ClientException;

    @Deprecated
    public DocumentModel restoreToVersion(DocumentRef var1, VersionModel var2) throws ClientException;

    public DocumentRef getBaseVersion(DocumentRef var1) throws ClientException;

    public void checkOut(DocumentRef var1) throws ClientException;

    @Deprecated
    public DocumentModel checkIn(DocumentRef var1, VersionModel var2) throws ClientException;

    public DocumentRef checkIn(DocumentRef var1, VersioningOption var2, String var3) throws ClientException;

    public boolean isCheckedOut(DocumentRef var1) throws ClientException;

    public String getVersionSeriesId(DocumentRef var1) throws ClientException;

    public DocumentModel getWorkingCopy(DocumentRef var1) throws ClientException;

    public DocumentModel createProxy(DocumentRef var1, DocumentRef var2) throws ClientException;

    public DocumentModelList query(String var1) throws ClientException;

    public DocumentModelList query(String var1, int var2) throws ClientException;

    public DocumentModelList query(String var1, Filter var2) throws ClientException;

    public DocumentModelList query(String var1, Filter var2, int var3) throws ClientException;

    public DocumentModelList query(String var1, Filter var2, long var3, long var5, boolean var7) throws ClientException;

    public DocumentModelList query(String var1, Filter var2, long var3, long var5, long var7) throws ClientException;

    public DocumentModelList query(String var1, String var2, Filter var3, long var4, long var6, boolean var8) throws ClientException;

    public DocumentModelList query(String var1, String var2, Filter var3, long var4, long var6, long var8) throws ClientException;

    public IterableQueryResult queryAndFetch(String var1, String var2, Object ... var3) throws ClientException;

    @Deprecated
    public DocumentModelIterator queryIt(String var1, Filter var2, int var3) throws ClientException;

    public List<String> getAvailableSecurityPermissions() throws ClientException;

    public String getCurrentLifeCycleState(DocumentRef var1) throws ClientException;

    public String getLifeCyclePolicy(DocumentRef var1) throws ClientException;

    public boolean followTransition(DocumentRef var1, String var2) throws ClientException;

    public boolean followTransition(DocumentModel var1, String var2) throws ClientException;

    public Collection<String> getAllowedStateTransitions(DocumentRef var1) throws ClientException;

    public void reinitLifeCycleState(DocumentRef var1) throws ClientException;

    public Object[] getDataModelsField(DocumentRef[] var1, String var2, String var3) throws ClientException;

    public DocumentRef[] getParentDocumentRefs(DocumentRef var1) throws ClientException;

    public Object[] getDataModelsFieldUp(DocumentRef var1, String var2, String var3) throws ClientException;

    @Deprecated
    public String getLock(DocumentRef var1) throws ClientException;

    @Deprecated
    @NoRollbackOnException
    public void setLock(DocumentRef var1, String var2) throws ClientException;

    @Deprecated
    @NoRollbackOnException
    public String unlock(DocumentRef var1) throws ClientException;

    @NoRollbackOnException
    public Lock setLock(DocumentRef var1) throws ClientException;

    public Lock getLockInfo(DocumentRef var1) throws ClientException;

    @NoRollbackOnException
    public Lock removeLock(DocumentRef var1) throws ClientException;

    public void applyDefaultPermissions(String var1) throws ClientException;

    public void destroy();

    @Deprecated
    public boolean isDirty(DocumentRef var1) throws ClientException;

    public DocumentModel publishDocument(DocumentModel var1, DocumentModel var2) throws ClientException;

    public DocumentModel publishDocument(DocumentModel var1, DocumentModel var2, boolean var3) throws ClientException;

    public DocumentModelList getProxies(DocumentRef var1, DocumentRef var2) throws ClientException;

    @Deprecated
    public String[] getProxyVersions(DocumentRef var1, DocumentRef var2) throws ClientException;

    public String getSuperParentType(DocumentModel var1) throws ClientException;

    public DocumentModel getSuperSpace(DocumentModel var1) throws ClientException;

    public String getRepositoryName();

    public <T extends Serializable> T getDocumentSystemProp(DocumentRef var1, String var2, Class<T> var3) throws ClientException, DocumentException;

    public <T extends Serializable> void setDocumentSystemProp(DocumentRef var1, String var2, T var3) throws ClientException, DocumentException;

    public void orderBefore(DocumentRef var1, String var2, String var3) throws ClientException;

    public <T> T run(Operation<T> var1) throws ClientException;

    public <T> T run(Operation<T> var1, ProgressMonitor var2) throws ClientException;

    public DocumentModel.DocumentModelRefresh refreshDocument(DocumentRef var1, int var2, String[] var3) throws ClientException;

    public String[] getPermissionsToCheck(String var1);

    public boolean supportsTags(String var1) throws ClientException;

    public boolean supportsTags() throws ClientException;

    public <T extends DetachedAdapter> T adaptFirstMatchingDocumentWithFacet(DocumentRef var1, String var2, Class<T> var3) throws ClientException;

    public Map<String, String> getBinaryFulltext(DocumentRef var1) throws ClientException;
}

