/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.operation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;

@Operation(id="Context.GetTaskNames", category="Workflow Context", label="Get Task Translated Names", description="Returns a list of current user open tasks where their translated name matches  ( partially or fully ) the 'searchTerm' parameter. This operation is invoked from a select2widget and")
public class GetTaskNamesOperation {
    public static final String ID = "Context.GetTaskNames";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="lang", required=false)
    protected String lang;
    @Param(name="searchTerm", required=false)
    protected String searchTerm;
    @Param(name="value", required=false)
    protected String value;
    @Param(name="xpath", required=false)
    protected String xpath;
    public static int LIMIT_RESULTS = 15;

    @OperationMethod
    public DocumentModelList run() {
        Locale locale;
        Locale locale2 = locale = this.lang != null && !this.lang.isEmpty() ? new Locale(this.lang) : Locale.ENGLISH;
        if (this.value != null && !"".equals(this.value)) {
            return this.getAllUserOpenTask(this.session, locale, this.value, false);
        }
        return this.getAllUserOpenTask(this.session, locale, this.searchTerm, true);
    }

    protected DocumentModelList getAllUserOpenTask(CoreSession session, Locale locale, String searchTerm, boolean partialMatch) {
        DocumentModelListImpl list = new DocumentModelListImpl();
        String query = "Select * from TaskDoc where ecm:mixinType IN ('RoutingTask') AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState = 'opened'";
        HashMap<String, DocumentModel> results = new HashMap<String, DocumentModel>();
        try {
            DocumentModelList docs = session.query(query);
            int i = 0;
            for (DocumentModel doc : docs) {
                String taskName = (String)((Object)doc.getPropertyValue("nt:name"));
                String taskLabel = this.getI18nLabel(taskName, locale);
                if (partialMatch) {
                    if (searchTerm == null || "".equals(searchTerm)) {
                        doc.setPropertyValue("dc:title", (Serializable)((Object)("[" + this.getWorkflowTranslatedTitle(doc, locale) + "]" + " " + taskLabel)));
                        results.put(taskName, doc);
                        ++i;
                    } else if (taskLabel.startsWith(searchTerm)) {
                        doc.setPropertyValue("dc:title", (Serializable)((Object)("[" + this.getWorkflowTranslatedTitle(doc, locale) + "]" + " " + taskLabel)));
                        results.put(taskName, doc);
                        ++i;
                    }
                }
                if (!partialMatch && searchTerm.equals(taskName)) {
                    doc.setPropertyValue("dc:title", (Serializable)((Object)("[" + this.getWorkflowTranslatedTitle(doc, locale) + "]" + " " + taskLabel)));
                    results.put(taskName, doc);
                    ++i;
                } else if (i <= LIMIT_RESULTS) continue;
                break;
            }
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        list.addAll(results.values());
        return list;
    }

    protected String getI18nLabel(String label, Locale locale) {
        if (label == null) {
            label = "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)locale);
    }

    protected String getWorkflowTranslatedTitle(DocumentModel taskDoc, Locale locale) throws PropertyException, ClientException {
        String workflowId = (String)((Object)taskDoc.getPropertyValue("nt:processId"));
        DocumentModel workflowDoc = this.session.getDocument((DocumentRef)new IdRef(workflowId));
        return this.getI18nLabel(workflowDoc.getTitle(), locale);
    }
}

