/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.adapters.CollectionShortCollection;
import org.apache.commons.collections.primitives.adapters.ShortIteratorIterator;

abstract class AbstractShortCollectionCollection
implements Collection<Short> {
    AbstractShortCollectionCollection() {
    }

    @Nonnull
    protected abstract ShortCollection getShortCollection();

    @Override
    public boolean add(Short s) {
        return this.getShortCollection().add(s);
    }

    @Override
    public boolean addAll(Collection<? extends Short> collection) {
        return this.getShortCollection().addAll(CollectionShortCollection.wrap(collection));
    }

    @Override
    public void clear() {
        this.getShortCollection().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getShortCollection().contains((Short)object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getShortCollection().containsAll(CollectionShortCollection.wrap(collection));
    }

    public String toString() {
        return this.getShortCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getShortCollection().isEmpty();
    }

    @Override
    public Iterator<Short> iterator() {
        return ShortIteratorIterator.wrap(this.getShortCollection().iterator());
    }

    @Override
    public boolean remove(Object object) {
        return this.getShortCollection().removeElement((Short)object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getShortCollection().removeAll(CollectionShortCollection.wrap(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getShortCollection().retainAll(CollectionShortCollection.wrap(collection));
    }

    @Override
    public int size() {
        return this.getShortCollection().size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Short[] toArray() {
        short[] sArray = this.getShortCollection().toArray();
        Short[] shortArray = new Short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            shortArray[i] = sArray[i];
        }
        return shortArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Short[] shortArray = this.toArray();
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(shortArray, n, TArray.getClass());
        }
        System.arraycopy(shortArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }
}

