/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.SchemaChecker;
import org.apache.directory.server.core.schema.SchemaManager;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.constants.SchemaConstants;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.ServerSearchResult;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.syntax.AbstractAdsSchemaDescription;
import org.apache.directory.shared.ldap.schema.syntax.AcceptAllSyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.EmptyEnumeration;
import org.apache.directory.shared.ldap.util.SingletonEnumeration;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaService
extends BaseInterceptor {
    private static Logger log = LoggerFactory.getLogger(SchemaService.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String BINARY_KEY = "java.naming.ldap.attributes.binary";
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private PartitionNexus nexus;
    private BinaryAttributeFilter binaryAttributeFilter;
    private TopFilter topFilter;
    private List<SearchResultFilter> filters = new ArrayList<SearchResultFilter>();
    private Registries registries;
    private Set<String> binaries;
    private LdapDN subschemaSubentryDn;
    private String subschemaSubentryDnNorm;
    private LdapDN schemaModificationAttributesDN;
    private SchemaManager schemaManager;
    private LdapDN schemaBaseDN;
    private Map<String, List<ObjectClass>> superiors;
    private Map<String, List<AttributeType>> allMay;
    private Map<String, List<AttributeType>> allMust;
    private Map<String, List<AttributeType>> allowed;
    private static final String[] schemaSubentryReturnAttributes = new String[]{"+", "*"};

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Initializing SchemaService...");
        }
        this.nexus = factoryCfg.getPartitionNexus();
        this.registries = factoryCfg.getRegistries();
        this.binaryAttributeFilter = new BinaryAttributeFilter();
        this.topFilter = new TopFilter();
        this.filters.add(this.binaryAttributeFilter);
        this.filters.add(this.topFilter);
        this.binaries = (Set)factoryCfg.getEnvironment().get(BINARY_KEY);
        if (this.binaries == null) {
            this.binaries = new HashSet<String>();
        }
        this.schemaBaseDN = new LdapDN("ou=schema");
        this.schemaBaseDN.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        this.schemaManager = factoryCfg.getSchemaManager();
        String subschemaSubentry = (String)this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = new LdapDN(subschemaSubentry);
        this.subschemaSubentryDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        this.subschemaSubentryDnNorm = this.subschemaSubentryDn.getNormName();
        this.schemaModificationAttributesDN = new LdapDN("cn=schemaModifications,ou=schema");
        this.schemaModificationAttributesDN.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        this.computeSuperiors();
        if (IS_DEBUG) {
            log.debug("SchemaService Initialized !");
        }
    }

    private void computeMustAttributes(ObjectClass objectClass, Set<String> atSeen) throws NamingException {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mustList = new ArrayList<AttributeType>();
        ArrayList<AttributeType> allowedList = new ArrayList<AttributeType>();
        HashSet<String> mustSeen = new HashSet<String>();
        this.allMust.put(objectClass.getOid(), mustList);
        this.allowed.put(objectClass.getOid(), allowedList);
        for (ObjectClass parent : parents) {
            AttributeType[] mustParent = parent.getMustList();
            if (mustParent == null || mustParent.length == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (mustSeen.contains(oid)) continue;
                mustSeen.add(oid);
                mustList.add(attributeType);
                allowedList.add(attributeType);
                atSeen.add(attributeType.getOid());
            }
        }
    }

    private void computeMayAttributes(ObjectClass objectClass, Set<String> atSeen) throws NamingException {
        List<ObjectClass> parents = this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mayList = new ArrayList<AttributeType>();
        HashSet<String> maySeen = new HashSet<String>();
        List<AttributeType> allowedList = this.allowed.get(objectClass.getOid());
        this.allMay.put(objectClass.getOid(), mayList);
        for (ObjectClass parent : parents) {
            AttributeType[] mustParent = parent.getMustList();
            if (mustParent == null || mustParent.length == 0) continue;
            for (AttributeType attributeType : mustParent) {
                String oid = attributeType.getOid();
                if (maySeen.contains(oid)) continue;
                maySeen.add(oid);
                mayList.add(attributeType);
                if (atSeen.contains(oid)) continue;
                allowedList.add(attributeType);
            }
        }
    }

    private void computeOCSuperiors(ObjectClass objectClass, List<ObjectClass> superiors, Set<String> ocSeen) throws NamingException {
        ObjectClass[] parents = objectClass.getSuperClasses();
        if (parents != null && parents.length != 0) {
            for (ObjectClass parent : parents) {
                if ("top".equals(parent.getName())) continue;
                this.computeOCSuperiors(parent, superiors, ocSeen);
                String oid = parent.getOid();
                if (ocSeen.contains(oid)) continue;
                superiors.add(parent);
                ocSeen.add(oid);
            }
        }
    }

    private void computeSuperiors() throws NamingException {
        Iterator objectClasses = this.registries.getObjectClassRegistry().iterator();
        this.superiors = new HashMap<String, List<ObjectClass>>();
        this.allMust = new HashMap<String, List<AttributeType>>();
        this.allMay = new HashMap<String, List<AttributeType>>();
        this.allowed = new HashMap<String, List<AttributeType>>();
        while (objectClasses.hasNext()) {
            ArrayList<ObjectClass> ocSuperiors = new ArrayList<ObjectClass>();
            ObjectClass objectClass = (ObjectClass)objectClasses.next();
            this.superiors.put(objectClass.getOid(), ocSuperiors);
            this.computeOCSuperiors(objectClass, ocSuperiors, new HashSet<String>());
            HashSet<String> atSeen = new HashSet<String>();
            this.computeMustAttributes(objectClass, atSeen);
            this.computeMayAttributes(objectClass, atSeen);
            this.superiors.put(objectClass.getName(), ocSuperiors);
        }
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws NamingException {
        NamingEnumeration<SearchResult> e = nextInterceptor.list(opContext);
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, this.binaryAttributeFilter, "List Schema Filter");
    }

    private void filterAttributesToReturn(SearchControls searchCtls) throws NamingException {
        String[] attributes = searchCtls.getReturningAttributes();
        if (attributes == null || attributes.length == 0) {
            searchCtls.setReturningAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
            return;
        }
        HashMap<String, String> filteredAttrs = new HashMap<String, String>();
        boolean hasNoAttribute = false;
        boolean hasAttributes = false;
        for (String attribute : attributes) {
            if ("*".equals(attribute) || "+".equals(attribute) || "1.1".equals(attribute)) {
                if (!filteredAttrs.containsKey(attribute)) {
                    filteredAttrs.put(attribute, attribute);
                }
                if ("1.1".equals(attribute)) {
                    hasNoAttribute = true;
                    continue;
                }
                hasAttributes = true;
                continue;
            }
            try {
                if (this.registries.getOidRegistry().hasOid(attribute)) {
                    String oid = this.registries.getOidRegistry().getOid(attribute);
                    if (this.registries.getAttributeTypeRegistry().hasAttributeType(oid) && !filteredAttrs.containsKey(oid)) {
                        filteredAttrs.put(oid, attribute);
                    }
                }
                hasAttributes = true;
            }
            catch (NamingException ne) {
                // empty catch block
            }
        }
        if (hasAttributes && hasNoAttribute) {
            filteredAttrs.remove("1.1");
        }
        if (filteredAttrs.size() == attributes.length) {
            return;
        }
        if (filteredAttrs.size() == 0) {
            searchCtls.setReturningAttributes(SchemaConstants.NO_ATTRIBUTE_ARRAY);
            return;
        }
        String[] newAttributesList = new String[filteredAttrs.size()];
        int pos = 0;
        for (String key : filteredAttrs.keySet()) {
            newAttributesList[pos++] = (String)filteredAttrs.get(key);
        }
        searchCtls.setReturningAttributes(newAttributesList);
    }

    @Override
    public NamingEnumeration<SearchResult> search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws NamingException {
        LdapDN base = opContext.getDn();
        SearchControls searchCtls = opContext.getSearchControls();
        ExprNode filter = opContext.getFilter();
        this.filterAttributesToReturn(searchCtls);
        if (!this.subschemaSubentryDnNorm.equals(base.toNormName())) {
            NamingEnumeration<SearchResult> e = nextInterceptor.search(opContext);
            Invocation invocation = InvocationStack.getInstance().peek();
            if (searchCtls.getReturningAttributes() != null) {
                return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, this.topFilter, "Search Schema Filter top");
            }
            return new SearchResultFilteringEnumeration(e, searchCtls, invocation, this.filters, "Search Schema Filter");
        }
        if (searchCtls.getSearchScope() == 0) {
            PresenceNode node;
            if (filter instanceof SimpleNode) {
                SimpleNode node2 = (SimpleNode)filter;
                String objectClass = null;
                objectClass = node2.getValue() instanceof String ? (String)node2.getValue() : node2.getValue().toString();
                String objectClassOid = null;
                if (!this.registries.getObjectClassRegistry().hasObjectClass(objectClass)) {
                    return new EmptyEnumeration();
                }
                objectClassOid = this.registries.getObjectClassRegistry().lookup(objectClass).getOid();
                String nodeOid = this.registries.getOidRegistry().getOid(node2.getAttribute());
                if (nodeOid.equals("2.5.4.0") && (objectClassOid.equals("2.5.6.0") || objectClassOid.equals("2.5.20.1")) && node2.getAssertionType() == AssertionEnum.EQUALITY) {
                    Attributes attrs = this.getSubschemaEntry(searchCtls.getReturningAttributes());
                    ServerSearchResult result = new ServerSearchResult(base.toString(), null, attrs);
                    return new SingletonEnumeration((Object)result);
                }
                return new EmptyEnumeration();
            }
            if (filter instanceof PresenceNode && (node = (PresenceNode)filter).getAttribute().equals("2.5.4.0")) {
                Attributes attrs = this.getSubschemaEntry(searchCtls.getReturningAttributes());
                ServerSearchResult result = new ServerSearchResult(base.toString(), null, attrs, false);
                return new SingletonEnumeration((Object)result);
            }
        }
        return new EmptyEnumeration();
    }

    private Attributes getSubschemaEntry(String[] ids) throws NamingException {
        Iterator list;
        AttributeImpl attr;
        if (ids == null) {
            ids = EMPTY_STRING_ARRAY;
        }
        HashSet<String> setOids = new HashSet<String>();
        AttributesImpl attrs = new AttributesImpl();
        boolean returnAllOperationalAttributes = false;
        for (String id : ids) {
            if ("+".equals(id)) {
                returnAllOperationalAttributes = true;
                continue;
            }
            if ("*".equals(id)) {
                setOids.add(id);
                continue;
            }
            setOids.add(this.registries.getOidRegistry().getOid(id));
        }
        if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.32")) {
            attr = new AttributeImpl("comparators");
            list = this.registries.getComparatorRegistry().comparatorDescriptionIterator();
            while (list.hasNext()) {
                ComparatorDescription description = (ComparatorDescription)list.next();
                attr.add((Object)SchemaUtils.render((AbstractAdsSchemaDescription)description).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.33")) {
            attr = new AttributeImpl("normalizers");
            list = this.registries.getNormalizerRegistry().normalizerDescriptionIterator();
            while (list.hasNext()) {
                NormalizerDescription normalizer = (NormalizerDescription)list.next();
                attr.add((Object)SchemaUtils.render((AbstractAdsSchemaDescription)normalizer).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.34")) {
            attr = new AttributeImpl("syntaxCheckers");
            list = this.registries.getSyntaxCheckerRegistry().syntaxCheckerDescriptionIterator();
            while (list.hasNext()) {
                SyntaxCheckerDescription syntaxCheckerDescription = (SyntaxCheckerDescription)list.next();
                attr.add((Object)SchemaUtils.render((AbstractAdsSchemaDescription)syntaxCheckerDescription).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("2.5.21.6")) {
            attr = new AttributeImpl("objectClasses");
            for (ObjectClass oc : this.registries.getObjectClassRegistry()) {
                attr.add((Object)SchemaUtils.render((ObjectClass)oc).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("2.5.21.5")) {
            attr = new AttributeImpl("attributeTypes");
            for (AttributeType at : this.registries.getAttributeTypeRegistry()) {
                attr.add((Object)SchemaUtils.render((AttributeType)at).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("2.5.21.4")) {
            attr = new AttributeImpl("matchingRules");
            for (MatchingRule mr : this.registries.getMatchingRuleRegistry()) {
                attr.add((Object)SchemaUtils.render((MatchingRule)mr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("2.5.21.8")) {
            attr = new AttributeImpl("matchingRuleUse");
            for (MatchingRuleUse mru : this.registries.getMatchingRuleUseRegistry()) {
                attr.add((Object)SchemaUtils.render((MatchingRuleUse)mru).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.1466.101.120.16")) {
            attr = new AttributeImpl("ldapSyntaxes");
            for (Syntax syntax : this.registries.getSyntaxRegistry()) {
                attr.add((Object)SchemaUtils.render((Syntax)syntax).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("2.5.21.2")) {
            attr = new AttributeImpl("ditContentRules");
            for (DITContentRule dcr : this.registries.getDitContentRuleRegistry()) {
                attr.add((Object)SchemaUtils.render((DITContentRule)dcr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("2.5.21.1")) {
            attr = new AttributeImpl("ditStructureRules");
            for (DITStructureRule dsr : this.registries.getDitStructureRuleRegistry()) {
                attr.add((Object)SchemaUtils.render((DITStructureRule)dsr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("2.5.21.7")) {
            attr = new AttributeImpl("nameForms");
            for (NameForm nf : this.registries.getNameFormRegistry()) {
                attr.add((Object)SchemaUtils.render((NameForm)nf).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("2.5.18.6")) {
            attr = new AttributeImpl("subtreeSpecification", (Object)"{}");
            attrs.put((Attribute)attr);
        }
        int minSetSize = 0;
        if (setOids.contains("+")) {
            ++minSetSize;
        }
        if (setOids.contains("*")) {
            ++minSetSize;
        }
        if (setOids.contains("ref")) {
            ++minSetSize;
        }
        if (setOids.contains("*") || setOids.contains("2.5.4.0") || setOids.size() == minSetSize) {
            attr = new AttributeImpl("objectClass");
            attr.add((Object)"top");
            attr.add((Object)"subschema");
            attr.add((Object)"subentry");
            attr.add((Object)"apacheSubschema");
            attrs.put((Attribute)attr);
        }
        if (setOids.contains("*") || setOids.contains("2.5.4.3") || setOids.size() == minSetSize) {
            attrs.put("cn", (Object)"schema");
        }
        Attributes modificationAttributes = this.nexus.lookup(new LookupOperationContext(this.schemaModificationAttributesDN));
        if (returnAllOperationalAttributes || setOids.contains("createTimestamp")) {
            attr = new AttributeImpl("createTimestamp");
            AttributeType createTimestampAT = this.registries.getAttributeTypeRegistry().lookup("createTimestamp");
            Attribute createTimestamp = AttributeUtils.getAttribute((Attributes)modificationAttributes, (AttributeType)createTimestampAT);
            attr.add(createTimestamp.get());
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("creatorsName")) {
            attr = new AttributeImpl("creatorsName");
            attr.add((Object)"uid=admin,ou=system");
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("modifyTimestamp")) {
            attr = new AttributeImpl("modifyTimestamp");
            AttributeType schemaModifyTimestampAT = this.registries.getAttributeTypeRegistry().lookup("schemaModifyTimestamp");
            Attribute schemaModifyTimestamp = AttributeUtils.getAttribute((Attributes)modificationAttributes, (AttributeType)schemaModifyTimestampAT);
            attr.add(schemaModifyTimestamp.get());
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || setOids.contains("modifiersName")) {
            attr = new AttributeImpl("modifiersName");
            AttributeType schemaModifiersNameAT = this.registries.getAttributeTypeRegistry().lookup("schemaModifiersName");
            Attribute schemaModifiersName = AttributeUtils.getAttribute((Attributes)modificationAttributes, (AttributeType)schemaModifiersNameAT);
            attr.add(schemaModifiersName.get());
            attrs.put((Attribute)attr);
        }
        return attrs;
    }

    @Override
    public Attributes lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws NamingException {
        Attributes result = nextInterceptor.lookup(opContext);
        if (result == null) {
            return null;
        }
        this.filterBinaryAttributes(result);
        this.filterObjectClass(result);
        return result;
    }

    private void getSuperiors(ObjectClass oc, Set<String> ocSeen, List<ObjectClass> result) throws NamingException {
        for (ObjectClass parent : oc.getSuperClasses()) {
            if ("top".equals(parent.getName())) continue;
            if (!ocSeen.contains(parent.getOid())) {
                ocSeen.add(parent.getOid());
                result.add(parent);
            }
            this.getSuperiors(parent, ocSeen, result);
        }
    }

    private boolean isRequired(String attrId, Attribute objectClass) throws NamingException {
        OidRegistry oidRegistry = this.registries.getOidRegistry();
        ObjectClassRegistry registry = this.registries.getObjectClassRegistry();
        if (!oidRegistry.hasOid(attrId)) {
            return false;
        }
        String attrOid = oidRegistry.getOid(attrId);
        for (int ii = 0; ii < objectClass.size(); ++ii) {
            ObjectClass ocSpec = registry.lookup((String)objectClass.get(ii));
            for (AttributeType must : ocSpec.getMustList()) {
                if (!must.getOid().equals(attrOid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCompleteRemoval(Attribute change, Attributes entry) throws NamingException {
        if (change.size() == 0) {
            return true;
        }
        Attribute changedEntryAttr = (Attribute)entry.get(change.getID()).clone();
        for (int jj = 0; jj < change.size(); ++jj) {
            changedEntryAttr.remove(change.get(jj));
        }
        return changedEntryAttr.size() == 0;
    }

    private Attribute getResultantObjectClasses(int modOp, Attribute changes, Attribute existing) throws NamingException {
        if (changes == null && existing == null) {
            return new AttributeImpl("objectClass");
        }
        if (changes == null) {
            return existing;
        }
        if (existing == null && modOp == 1) {
            return changes;
        }
        if (existing == null) {
            return new AttributeImpl("objectClass");
        }
        switch (modOp) {
            case 1: {
                return AttributeUtils.getUnion((Attribute)existing, (Attribute)changes);
            }
            case 2: {
                return (Attribute)changes.clone();
            }
            case 3: {
                return AttributeUtils.getDifference((Attribute)existing, (Attribute)changes);
            }
        }
        throw new InternalError("");
    }

    private boolean getObjectClasses(Attribute objectClasses, List<ObjectClass> result) throws NamingException {
        HashSet<String> ocSeen = new HashSet<String>();
        ObjectClassRegistry registry = this.registries.getObjectClassRegistry();
        NamingEnumeration<?> ocs = objectClasses.getAll();
        boolean hasExtensibleObject = false;
        while (ocs.hasMoreElements()) {
            ObjectClass oc;
            String objectClassName = (String)ocs.nextElement();
            if ("top".equals(objectClassName)) continue;
            if ("extensibleObject".equalsIgnoreCase(objectClassName)) {
                hasExtensibleObject = true;
            }
            if (!ocSeen.contains((oc = registry.lookup(objectClassName)).getOid())) {
                ocSeen.add(oc.getOid());
                result.add(oc);
            }
            this.getSuperiors(oc, ocSeen, result);
        }
        return hasExtensibleObject;
    }

    private Set<String> getAllMust(NamingEnumeration objectClasses) throws NamingException {
        HashSet<String> must = new HashSet<String>();
        while (objectClasses.hasMoreElements()) {
            String ocName = (String)objectClasses.nextElement();
            ObjectClass oc = this.registries.getObjectClassRegistry().lookup(ocName);
            AttributeType[] types = oc.getMustList();
            if (types == null || types.length <= 0) continue;
            for (AttributeType type : types) {
                must.add(type.getOid());
            }
        }
        return must;
    }

    private Set<String> getAllAllowed(NamingEnumeration objectClasses, Set<String> must) throws NamingException {
        HashSet<String> allowed = new HashSet<String>(must);
        allowed.add(this.registries.getOidRegistry().getOid("objectClass"));
        while (objectClasses.hasMoreElements()) {
            String ocName = (String)objectClasses.nextElement();
            ObjectClass oc = this.registries.getObjectClassRegistry().lookup(ocName);
            AttributeType[] types = oc.getMayList();
            if (types == null || types.length <= 0) continue;
            for (AttributeType type : types) {
                String oid = type.getOid();
                allowed.add(oid);
            }
        }
        return allowed;
    }

    private void alterObjectClasses(Attribute objectClassAttr) throws NamingException {
        HashSet<String> objectClasses = new HashSet<String>();
        HashSet<String> objectClassesUP = new HashSet<String>();
        objectClasses.add("top");
        objectClassesUP.add("top");
        NamingEnumeration<?> ocList = objectClassAttr.getAll();
        while (ocList.hasMoreElements()) {
            List<ObjectClass> ocSuperiors;
            String ocName = (String)ocList.nextElement();
            if (ocName.equalsIgnoreCase("top")) continue;
            String ocLowerName = ocName.toLowerCase();
            ObjectClass objectClass = this.registries.getObjectClassRegistry().lookup(ocLowerName);
            if (!objectClasses.contains(ocLowerName)) {
                objectClasses.add(ocLowerName);
                objectClassesUP.add(ocName);
            }
            if ((ocSuperiors = this.superiors.get(objectClass.getOid())) == null) continue;
            for (ObjectClass oc : ocSuperiors) {
                if (objectClasses.contains(oc.getName().toLowerCase())) continue;
                objectClasses.add(oc.getName());
                objectClassesUP.add(oc.getName());
            }
        }
        objectClassAttr.clear();
        for (String attribute : objectClassesUP) {
            objectClassAttr.add(attribute);
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws NamingException {
        LdapDN oriChildName = opContext.getDn();
        Attributes entry = this.nexus.lookup(new LookupOperationContext(oriChildName));
        if (oriChildName.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.move(oriChildName, opContext.getParent(), opContext.getNewRdn(), opContext.getDelOldDn(), entry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        }
        next.moveAndRename(opContext);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws NamingException {
        LdapDN oriChildName = opContext.getDn();
        Attributes entry = this.nexus.lookup(new LookupOperationContext(oriChildName));
        if (oriChildName.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.replace(oriChildName, opContext.getParent(), entry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        }
        next.move(opContext);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        String newRdn = opContext.getNewRdn();
        boolean deleteOldRn = opContext.getDelOldDn();
        Attributes entry = this.nexus.lookup(new LookupOperationContext(name));
        if (name.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.modifyRn(name, newRdn, deleteOldRn, entry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        }
        next.rename(opContext);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws NamingException {
        Attribute objectClass;
        Attributes entry = null;
        LdapDN name = opContext.getDn();
        ModificationItemImpl[] mods = opContext.getModItems();
        entry = name.getNormName().equalsIgnoreCase(this.subschemaSubentryDnNorm) ? this.getSubschemaEntry(schemaSubentryReturnAttributes) : this.nexus.lookup(new LookupOperationContext(name));
        Attributes targetEntry = SchemaUtils.getTargetEntry((ModificationItemImpl[])mods, (Attributes)entry);
        if (entry == null) {
            log.error("No entry with this name :{}", (Object)name);
            throw new LdapNameNotFoundException("The entry which name is " + name + " is not found.");
        }
        Attributes tmpEntry = (Attributes)entry.clone();
        HashSet<String> modset = new HashSet<String>();
        ModificationItemImpl objectClassMod = null;
        for (ModificationItemImpl mod : mods) {
            if (mod.getAttribute().getID().equalsIgnoreCase("objectClass")) {
                objectClassMod = mod;
            }
            if (mod.getAttribute().size() == 0 && mod.getModificationOp() == 1) {
                throw new LdapInvalidAttributeValueException("No value is not a valid value for an attribute.", ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            }
            StringBuffer keybuf = new StringBuffer();
            keybuf.append(mod.getModificationOp());
            keybuf.append(mod.getAttribute().getID());
            for (int jj = 0; jj < mod.getAttribute().size(); ++jj) {
                keybuf.append(mod.getAttribute().get(jj));
            }
            if (modset.add(keybuf.toString()) || mod.getModificationOp() != 1) continue;
            throw new LdapAttributeInUseException("found two copies of the following modification item: " + mod);
        }
        if (objectClassMod == null) {
            objectClass = entry.get("objectClass");
            if (objectClass == null) {
                objectClass = new AttributeImpl("objectClass");
            }
        } else {
            objectClass = this.getResultantObjectClasses(objectClassMod.getModificationOp(), objectClassMod.getAttribute(), entry.get("objectClass"));
        }
        ObjectClassRegistry ocRegistry = this.registries.getObjectClassRegistry();
        AttributeTypeRegistry atRegistry = this.registries.getAttributeTypeRegistry();
        if (mods.length == 1 && mods[0].getAttribute().size() == 0 && mods[0].getModificationOp() == 2 && !atRegistry.hasAttributeType(mods[0].getAttribute().getID())) {
            return;
        }
        block12: for (ModificationItemImpl mod : mods) {
            int modOp = mod.getModificationOp();
            Attribute change = mod.getAttribute();
            if (!atRegistry.hasAttributeType(change.getID()) && !objectClass.contains("extensibleObject")) {
                throw new LdapInvalidAttributeIdentifierException();
            }
            AttributeType attributeType = atRegistry.lookup(change.getID());
            if (!attributeType.isCanUserModify()) {
                throw new NoPermissionException("Cannot modify the attribute '" + change.getID() + "'");
            }
            switch (modOp) {
                case 1: {
                    NamingEnumeration<?> values;
                    Attribute attr = tmpEntry.get(change.getID());
                    if (attr != null) {
                        values = change.getAll();
                        while (values.hasMoreElements()) {
                            attr.add(values.nextElement());
                        }
                        continue block12;
                    }
                    attr = new AttributeImpl(change.getID());
                    values = change.getAll();
                    while (values.hasMoreElements()) {
                        attr.add(values.nextElement());
                    }
                    tmpEntry.put(attr);
                    continue block12;
                }
                case 3: {
                    if (tmpEntry.get(change.getID()) == null) {
                        log.error("Trying to remove an non-existant attribute: " + change.getID());
                        throw new LdapNoSuchAttributeException();
                    }
                    if (change.size() == 0) {
                        if (this.isRequired(change.getID(), objectClass)) {
                            log.error("Trying to remove a required attribute: " + change.getID());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                        }
                    } else {
                        if (this.isRequired(change.getID(), objectClass) && this.isCompleteRemoval(change, entry)) {
                            log.error("Trying to remove a required attribute: " + change.getID());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                        }
                        Attribute modified = tmpEntry.remove(change.getID());
                        NamingEnumeration<?> values = change.getAll();
                        while (values.hasMoreElements()) {
                            modified.remove(values.next());
                        }
                        if (modified.size() == 0 && this.isRequired(change.getID(), objectClass)) {
                            log.error("Trying to remove a required attribute: " + change.getID());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION);
                        }
                        tmpEntry.put(modified);
                    }
                    SchemaChecker.preventRdnChangeOnModifyRemove((Name)name, modOp, change, this.registries.getOidRegistry());
                    SchemaChecker.preventStructuralClassRemovalOnModifyRemove(ocRegistry, (Name)name, modOp, change, objectClass);
                    continue block12;
                }
                case 2: {
                    SchemaChecker.preventRdnChangeOnModifyReplace((Name)name, modOp, change, this.registries.getOidRegistry());
                    SchemaChecker.preventStructuralClassRemovalOnModifyReplace(ocRegistry, (Name)name, modOp, change);
                    Attribute attr = tmpEntry.get(change.getID());
                    if (attr != null) {
                        tmpEntry.remove(change.getID());
                    }
                    attr = new AttributeImpl(change.getID());
                    NamingEnumeration<?> values = change.getAll();
                    if (!values.hasMoreElements()) continue block12;
                    while (values.hasMoreElements()) {
                        attr.add(values.nextElement());
                    }
                    tmpEntry.put(attr);
                }
            }
        }
        this.check(name, tmpEntry);
        if (objectClassMod != null) {
            Attribute alteredObjectClass = (Attribute)objectClass.clone();
            this.alterObjectClasses(alteredObjectClass);
            if (!alteredObjectClass.equals(objectClass)) {
                Attribute ocMods = objectClassMod.getAttribute();
                switch (objectClassMod.getModificationOp()) {
                    case 1: {
                        int ii;
                        if (ocMods.contains("top")) {
                            ocMods.remove("top");
                        }
                        for (ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (objectClass.contains(alteredObjectClass.get(ii))) continue;
                            ocMods.add(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                    case 3: {
                        int ii;
                        for (ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (objectClass.contains(alteredObjectClass.get(ii))) continue;
                            ocMods.remove(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                    case 2: {
                        int ii;
                        for (ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (objectClass.contains(alteredObjectClass.get(ii))) continue;
                            ocMods.add(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                }
            }
        }
        if (name.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.modify(name, mods, entry, targetEntry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        } else if (this.subschemaSubentryDnNorm.equals(name.getNormName())) {
            this.schemaManager.modifySchemaSubentry(name, mods, entry, targetEntry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
            return;
        }
        next.modify(opContext);
    }

    private void filterObjectClass(Attributes entry) throws NamingException {
        ArrayList<ObjectClass> objectClasses = new ArrayList<ObjectClass>();
        Attribute oc = entry.get("objectClass");
        if (oc != null) {
            this.getObjectClasses(oc, objectClasses);
            entry.remove("objectClass");
            AttributeImpl newOc = new AttributeImpl("objectClass");
            for (ObjectClass currentOC : objectClasses) {
                if (currentOC instanceof String) {
                    newOc.add(currentOC);
                    continue;
                }
                newOc.add(currentOC.getName());
            }
            newOc.add("top");
            entry.put((Attribute)newOc);
        }
    }

    private void filterBinaryAttributes(Attributes entry) throws NamingException {
        NamingEnumeration<String> list = entry.getIDs();
        while (list.hasMore()) {
            String id = list.next();
            AttributeType type = null;
            boolean asBinary = false;
            if (!this.registries.getAttributeTypeRegistry().hasAttributeType(id)) continue;
            type = this.registries.getAttributeTypeRegistry().lookup(id);
            asBinary = !type.getSyntax().isHumanReadable();
            asBinary = asBinary || this.binaries != null && this.binaries.contains(type);
            if (!(asBinary = asBinary || this.binaries.contains(type))) continue;
            Attribute attribute = entry.get(id);
            AttributeImpl binary = new AttributeImpl(id);
            for (int i = 0; i < attribute.size(); ++i) {
                Object value = attribute.get(i);
                if (value instanceof String) {
                    binary.add(i, StringTools.getBytesUtf8((String)((String)value)));
                    continue;
                }
                binary.add(i, value);
            }
            entry.remove(id);
            entry.put((Attribute)binary);
        }
    }

    private void check(LdapDN dn, Attributes entry) throws NamingException {
        NamingEnumeration<String> attrEnum = entry.getIDs();
        while (attrEnum.hasMoreElements()) {
            String name = (String)attrEnum.nextElement();
            if (this.registries.getAttributeTypeRegistry().hasAttributeType(name)) continue;
            throw new LdapInvalidAttributeIdentifierException(name + " not found in attribute registry!");
        }
        Attribute objectClassAttr = entry.get("objectClass");
        if (objectClassAttr == null) {
            objectClassAttr = new AttributeImpl("objectClass");
        }
        ArrayList<ObjectClass> ocs = new ArrayList<ObjectClass>();
        this.alterObjectClasses(objectClassAttr);
        Set<String> must = this.getAllMust(objectClassAttr.getAll());
        Set<String> allowed = this.getAllAllowed(objectClassAttr.getAll(), must);
        boolean hasExtensibleObject = this.getObjectClasses(objectClassAttr, ocs);
        this.assertObjectClasses(dn, ocs);
        this.assertRequiredAttributesPresent(dn, entry, must);
        this.assertNumberOfAttributeValuesValid(entry);
        if (!hasExtensibleObject) {
            this.assertAllAttributesAllowed(dn, entry, allowed);
        }
        this.assertHumanReadable(entry);
        this.assertSyntaxes(entry);
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        Attributes attrs = opContext.getEntry();
        this.check(name, attrs);
        if (name.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.add(name, attrs);
        }
        next.add(opContext);
    }

    private void assertAllAttributesAllowed(LdapDN dn, Attributes attributes, Set<String> allowed) throws NamingException {
        Attribute objectClass = attributes.get("objectClass");
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"extensibleObject")) {
            return;
        }
        NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
        while (attrs.hasMoreElements()) {
            Attribute attribute = (Attribute)attrs.nextElement();
            String attrId = attribute.getID();
            String attrOid = this.registries.getOidRegistry().getOid(attrId);
            AttributeType attributeType = this.registries.getAttributeTypeRegistry().lookup(attrOid);
            if (attributeType.isCollective() || attributeType.getUsage() != UsageEnum.USER_APPLICATIONS || allowed.contains(attrOid)) continue;
            throw new LdapSchemaViolationException("Attribute " + attribute.getID() + " not declared in objectClasses of entry " + dn.getUpName(), ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws NamingException {
        LdapDN name = opContext.getDn();
        Attributes entry = this.nexus.lookup(new LookupOperationContext(name));
        if (name.startsWith((Name)this.schemaBaseDN)) {
            this.schemaManager.delete(name, entry, opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"));
        }
        next.delete(opContext);
    }

    private void assertNumberOfAttributeValuesValid(Attributes attributes) throws InvalidAttributeValueException, NamingException {
        NamingEnumeration<? extends Attribute> list = attributes.getAll();
        while (list.hasMore()) {
            Attribute attribute = list.next();
            this.assertNumberOfAttributeValuesValid(attribute);
        }
    }

    private void assertNumberOfAttributeValuesValid(Attribute attribute) throws InvalidAttributeValueException, NamingException {
        AttributeTypeRegistry registry = this.registries.getAttributeTypeRegistry();
        if (attribute.size() > 1 && registry.lookup(attribute.getID()).isSingleValue()) {
            throw new LdapInvalidAttributeValueException("More than one value has been provided for the single-valued attribute: " + attribute.getID(), ResultCodeEnum.CONSTRAINT_VIOLATION);
        }
    }

    private void assertRequiredAttributesPresent(LdapDN dn, Attributes entry, Set<String> must) throws NamingException {
        NamingEnumeration<? extends Attribute> attributes = entry.getAll();
        while (attributes.hasMoreElements() && must.size() > 0) {
            Attribute attribute = (Attribute)attributes.nextElement();
            String oid = this.registries.getOidRegistry().getOid(attribute.getID());
            must.remove(oid);
        }
        if (must.size() != 0) {
            throw new LdapSchemaViolationException("Required attributes " + must + " not found within entry " + dn.getUpName(), ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
    }

    private void assertObjectClasses(LdapDN dn, List<ObjectClass> ocs) throws NamingException {
        HashSet<ObjectClass> structuralObjectClasses = new HashSet<ObjectClass>();
        for (ObjectClass oc : ocs) {
            if (!oc.isStructural()) continue;
            structuralObjectClasses.add(oc);
        }
        if (structuralObjectClasses.isEmpty()) {
            String message = "Entry " + dn + " does not contain a STRUCTURAL ObjectClass";
            log.error(message);
            throw new LdapSchemaViolationException(message, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        HashSet<ObjectClass> remaining = new HashSet<ObjectClass>(structuralObjectClasses.size());
        remaining.addAll(structuralObjectClasses);
        for (ObjectClass oc : structuralObjectClasses) {
            if (oc.getSuperClasses() == null) continue;
            for (ObjectClass superClass : oc.getSuperClasses()) {
                if (!superClass.isStructural()) continue;
                remaining.remove(superClass);
            }
        }
        if (remaining.size() > 1) {
            String message = "Entry " + dn + " contains more than one STRUCTURAL ObjectClass: " + remaining;
            log.error(message);
            throw new LdapSchemaViolationException(message, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
    }

    private void assertSyntaxes(Attributes entry) throws NamingException {
        NamingEnumeration<? extends Attribute> attributes = entry.getAll();
        while (attributes.hasMoreElements()) {
            Attribute attribute = (Attribute)attributes.nextElement();
            AttributeType attributeType = this.registries.getAttributeTypeRegistry().lookup(attribute.getID());
            SyntaxChecker syntaxChecker = this.registries.getSyntaxCheckerRegistry().lookup(attributeType.getSyntax().getOid());
            if (syntaxChecker instanceof AcceptAllSyntaxChecker) continue;
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                try {
                    syntaxChecker.assertSyntax(value);
                }
                catch (NamingException ne) {
                    String message = "Attribute value '" + (value instanceof String ? value : StringTools.dumpBytes((byte[])((byte[])value))) + "' for attribute '" + attribute.getID() + "' is syntactically incorrect";
                    log.info(message);
                    throw new LdapInvalidAttributeValueException(message, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                }
            }
        }
    }

    private void assertHumanReadable(Attributes entry) throws NamingException {
        Attribute attribute;
        NamingEnumeration<? extends Attribute> attributes = entry.getAll();
        boolean isEntryModified = false;
        Attributes cloneEntry = null;
        while (attributes.hasMoreElements()) {
            attribute = (Attribute)attributes.nextElement();
            AttributeType attributeType = this.registries.getAttributeTypeRegistry().lookup(attribute.getID());
            if (!attributeType.getSyntax().isHumanReadable()) continue;
            NamingEnumeration<?> values = attribute.getAll();
            Attribute clone = null;
            boolean isModified = false;
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (value instanceof String) continue;
                if (value instanceof byte[]) {
                    try {
                        String valStr = new String((byte[])value, "UTF-8");
                        if (!isModified) {
                            isModified = true;
                            clone = (Attribute)attribute.clone();
                        }
                        clone.remove(value);
                        clone.add(valStr);
                        continue;
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new NamingException("The value is not a valid String");
                    }
                }
                throw new NamingException("The value stored in an Human Readable attribute is not a String");
            }
            if (!isModified) continue;
            if (!isEntryModified) {
                cloneEntry = (Attributes)entry.clone();
                isEntryModified = true;
            }
            cloneEntry.remove(attribute.getID());
            cloneEntry.put(clone);
        }
        if (isEntryModified) {
            attributes = cloneEntry.getAll();
            while (attributes.hasMoreElements()) {
                attribute = (Attribute)attributes.nextElement();
                entry.remove(attribute.getID());
                entry.put(attribute);
            }
        }
    }

    private class TopFilter
    implements SearchResultFilter {
        private TopFilter() {
        }

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            SchemaService.this.filterObjectClass(result.getAttributes());
            return true;
        }
    }

    private class BinaryAttributeFilter
    implements SearchResultFilter {
        private BinaryAttributeFilter() {
        }

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            SchemaService.this.filterBinaryAttributes(result.getAttributes());
            return true;
        }
    }
}

