/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.node.ObjectNode;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestCleanupHandler;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.runtime.api.Framework;

public class JSONBatchBlobDecoder
implements JSONBlobDecoder {
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        Blob blob = null;
        if (!jsonObject.has("upload-batch")) {
            return null;
        }
        final String batchId = jsonObject.get("upload-batch").getTextValue();
        String fileId = null;
        if (jsonObject.has("upload-fileId")) {
            fileId = jsonObject.get("upload-fileId").getTextValue();
        }
        if (fileId != null) {
            BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
            blob = bm.getBlob(batchId, fileId);
            if (RequestContext.getActiveContext() != null) {
                RequestContext.getActiveContext().addRequestCleanupHandler(new RequestCleanupHandler(){

                    public void cleanup(HttpServletRequest request) {
                        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
                        bm.clean(batchId);
                    }
                });
            }
        }
        return blob;
    }
}

