/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.doc;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.ecm.webengine.jaxrs.views.TemplateView;
import org.nuxeo.runtime.api.Framework;

public class DocResource {
    private final Log log = LogFactory.getLog(DocResource.class);
    protected AutomationService service;
    protected List<OperationDocumentation> ops;

    public DocResource() {
        try {
            this.service = (AutomationService)Framework.getService(AutomationService.class);
            this.ops = this.service.getDocumentation();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to get automation service", (Throwable)e);
            throw new WebApplicationException((Throwable)e, 500);
        }
    }

    protected TemplateView getTemplate() {
        return this.getTemplate("index.ftl");
    }

    protected TemplateView getTemplate(String name) {
        LinkedHashMap<String, ArrayList<OperationDocumentation>> cats = new LinkedHashMap<String, ArrayList<OperationDocumentation>>();
        for (OperationDocumentation op : this.ops) {
            ArrayList<OperationDocumentation> list = (ArrayList<OperationDocumentation>)cats.get(op.getCategory());
            if (list == null) {
                list = new ArrayList<OperationDocumentation>();
                cats.put(op.getCategory(), list);
            }
            list.add(op);
        }
        return new TemplateView((Object)this, name).arg("categories", cats).arg("operations", this.ops);
    }

    @GET
    @Produces(value={"text/html"})
    public Object doGet(@QueryParam(value="id") String id) {
        if (id == null) {
            return this.getTemplate();
        }
        OperationDocumentation opDoc = null;
        for (OperationDocumentation op : this.ops) {
            if (!op.getId().equals(id)) continue;
            opDoc = op;
            break;
        }
        if (opDoc == null) {
            throw new WebApplicationException(Response.status((int)404).build());
        }
        TemplateView tpl = this.getTemplate();
        tpl.arg("operation", opDoc);
        return tpl;
    }

    protected boolean canManageTraces() {
        return ((NuxeoPrincipal)WebEngine.getActiveContext().getPrincipal()).isAdministrator();
    }

    @GET
    @Path(value="wiki")
    @Produces(value={"text/html"})
    public Object doGetWiki() {
        return this.getTemplate("wiki.ftl");
    }

    public boolean isTraceEnabled() {
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        return tracerFactory.getRecordingState();
    }

    @GET
    @Path(value="toggleTraces")
    @Produces(value={"text/html"})
    public Object toggleTraces() throws Exception {
        if (!this.canManageTraces()) {
            return "You can not manage traces";
        }
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        tracerFactory.toggleRecording();
        HttpServletRequest request = RequestContext.getActiveContext().getRequest();
        String url = request.getHeader("Referer");
        return Response.seeOther((URI)new URI(url)).build();
    }

    @GET
    @Path(value="traces")
    @Produces(value={"text/plain"})
    public String doGetTrace(@QueryParam(value="opId") String opId) {
        if (!this.canManageTraces()) {
            return "You can not manage traces";
        }
        TracerFactory tracerFactory = (TracerFactory)Framework.getLocalService(TracerFactory.class);
        Trace trace = tracerFactory.getTrace(opId);
        if (trace != null) {
            return tracerFactory.getTrace(opId).getFormattedText();
        }
        return "no trace";
    }

    public String[] getInputs(OperationDocumentation op) {
        if (op == null) {
            throw new IllegalArgumentException("Operation must not be null");
        }
        if (op.signature == null || op.signature.length == 0) {
            return new String[0];
        }
        String[] result = new String[op.signature.length / 2];
        int i = 0;
        int k = 0;
        while (i < op.signature.length) {
            result[k] = op.signature[i];
            i += 2;
            ++k;
        }
        return result;
    }

    public String[] getOutputs(OperationDocumentation op) {
        if (op == null) {
            throw new IllegalArgumentException("Operation must not be null");
        }
        if (op.signature == null || op.signature.length == 0) {
            return new String[0];
        }
        String[] result = new String[op.signature.length / 2];
        int i = 1;
        int k = 0;
        while (i < op.signature.length) {
            result[k] = op.signature[i];
            i += 2;
            ++k;
        }
        return result;
    }

    public String getInputsAsString(OperationDocumentation op) {
        Object[] result = this.getInputs(op);
        if (result == null || result.length == 0) {
            return "void";
        }
        return StringUtils.join((Object[])result, (String)", ");
    }

    public String getOutputsAsString(OperationDocumentation op) {
        Object[] result = this.getOutputs(op);
        if (result == null || result.length == 0) {
            return "void";
        }
        return StringUtils.join((Object[])result, (String)", ");
    }

    public String getParamDefaultValue(OperationDocumentation.Param param) {
        if (param.values != null && param.values.length > 0) {
            return StringUtils.join((Object[])param.values, (String)", ");
        }
        return "";
    }

    public boolean hasOperation(OperationDocumentation op) {
        if (op == null) {
            throw new IllegalArgumentException("Operation must not be null");
        }
        return op.getOperations() != null && op.getOperations().length != 0;
    }
}

