/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSSelectorSimpleMember
implements ICSSSelectorMember {
    private final String m_sValue;

    public CSSSelectorSimpleMember(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText((CharSequence)string)) {
            throw new IllegalArgumentException("empty value is not allowed");
        }
        this.m_sValue = string;
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    public boolean isElementName() {
        return !this.isHash() && !this.isClass() && !this.isPseudo();
    }

    public boolean isHash() {
        return this.m_sValue.charAt(0) == '#';
    }

    public boolean isClass() {
        return this.m_sValue.charAt(0) == '.';
    }

    public boolean isPseudo() {
        return this.m_sValue.charAt(0) == ':';
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSSelectorSimpleMember)) {
            return false;
        }
        CSSSelectorSimpleMember cSSSelectorSimpleMember = (CSSSelectorSimpleMember)object;
        return this.m_sValue.equals(cSSSelectorSimpleMember.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).toString();
    }
}

