/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.writer;

import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.reader.CSSReader;
import com.phloc.css.writer.CSSWriter;
import com.phloc.css.writer.CSSWriterSettings;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSCompressor {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSCompressor.class);

    private CSSCompressor() {
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSCompressor.getCompressedCSS(string, charset, eCSSVersion, false);
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, boolean bl) {
        CSSWriterSettings cSSWriterSettings = new CSSWriterSettings(eCSSVersion, true);
        cSSWriterSettings.setRemoveUnnecessaryCode(bl);
        return CSSCompressor.getRewrittenCSS(string, charset, cSSWriterSettings);
    }

    @Nonnull
    public static String getRewrittenCSS(@Nonnull String string, @Nonnull Charset charset, @Nonnull CSSWriterSettings cSSWriterSettings) {
        if (string == null) {
            throw new NullPointerException("originalCSS");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (cSSWriterSettings == null) {
            throw new NullPointerException("settings");
        }
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string, charset, cSSWriterSettings.getVersion());
        if (cascadingStyleSheet != null) {
            try {
                return new CSSWriter(cSSWriterSettings).getCSSAsString(cascadingStyleSheet);
            }
            catch (IOException iOException) {
                s_aLogger.warn("Failed to write optimized CSS!", (Throwable)iOException);
            }
        }
        return string;
    }
}

