/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.Collection;
import java.util.Iterator;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public abstract class SQLBaseProperty
implements Property {
    protected final Type type;
    protected final SQLDocument doc;
    protected final String name;

    public SQLBaseProperty(Type type, String name, SQLDocument doc) {
        this.type = type;
        this.doc = doc;
        this.name = name;
    }

    public SQLDocument getDocument() {
        return this.doc;
    }

    public SQLSession getSession() {
        return (SQLSession)this.getDocument().getSession();
    }

    public void checkWritable() throws DocumentException {
        this.getDocument().checkWritable(this.name);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNull() {
        throw new UnsupportedOperationException();
    }

    public void setNull() throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public boolean isPropertySet(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Property getProperty(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Collection<Property> getProperties() throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Iterator<Property> getPropertyIterator() throws DocumentException {
        throw new UnsupportedOperationException();
    }
}

