/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLDocumentVersion
extends SQLDocumentLive {
    private final Node versionableNode;

    protected SQLDocumentVersion(Node node, ComplexType type, List<CompositeType> mixinTypes, SQLSession session, boolean readonly) throws DocumentException {
        super(node, type, mixinTypes, session, readonly);
        this.versionableNode = session.getNodeById((Serializable)this.getProperty("ecm:versionableId").getValue());
    }

    @Override
    public boolean isVersion() {
        return true;
    }

    @Override
    public boolean isCheckedOut() throws DocumentException {
        return false;
    }

    @Override
    public boolean isVersionSeriesCheckedOut() throws DocumentException {
        if (this.versionableNode == null) {
            return false;
        }
        try {
            Boolean b = (Boolean)this.versionableNode.getSimpleProperty("ecm:isCheckedIn").getValue();
            return b == null ? true : b == false;
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    @Override
    public boolean isMajorVersion() throws DocumentException {
        return Long.valueOf(0L).equals(this.getProperty("ecm:minorVersion").getValue());
    }

    @Override
    public boolean isLatestVersion() throws DocumentException {
        return this.getBoolean("ecm:isLatestVersion");
    }

    @Override
    public boolean isLatestMajorVersion() throws DocumentException {
        return this.getBoolean("ecm:isLatestMajorVersion");
    }

    @Override
    public Document getWorkingCopy() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getDocumentByUUID(this.versionableNode.getId().toString());
    }

    @Override
    public Document getBaseVersion() throws DocumentException {
        return null;
    }

    @Override
    public String getVersionSeriesId() throws DocumentException {
        Serializable versionSeriesId = (Serializable)this.getPropertyValue("ecm:versionableId");
        return this.session.idToString(versionSeriesId);
    }

    @Override
    public Document getSourceDocument() throws DocumentException {
        return this.getWorkingCopy();
    }

    @Override
    public String getPath() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getPath(this.versionableNode);
    }

    @Override
    public Document getParent() throws DocumentException {
        if (this.versionableNode == null) {
            return null;
        }
        return this.session.getParent(this.versionableNode);
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public void removeChild(String name) throws DocumentException {
        throw new VersionNotModifiableException();
    }

    @Override
    public void orderBefore(String src, String dest) throws DocumentException {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document addChild(String name, String typeName) throws DocumentException {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document getChild(String name) throws DocumentException {
        throw new NoSuchDocumentException(name);
    }

    @Override
    public Iterator<Document> getChildren() throws DocumentException {
        return EmptyDocumentIterator.INSTANCE;
    }

    @Override
    public List<String> getChildrenIds() throws DocumentException {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChild(String name) throws DocumentException {
        return false;
    }

    @Override
    public boolean hasChildren() throws DocumentException {
        return false;
    }

    @Override
    public Document checkIn(String label, String description) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void checkOut() {
        throw new VersionNotModifiableException();
    }

    @Override
    public void restore(Document version) {
        throw new VersionNotModifiableException();
    }

    @Override
    public Document getVersion(String label) {
        return null;
    }

    @Override
    public List<Document> getVersions() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasVersions() {
        return false;
    }

    @Override
    public Document getLastVersion() {
        return null;
    }

    @Override
    public void importFlatMap(Map<String, Object> map) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void importMap(Map<String, Map<String, Object>> map) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void setPropertyValue(String name, Object value) throws DocumentException {
        if (this.isReadOnlyProperty(name)) {
            throw new VersionNotModifiableException(String.format("Cannot set property on a version: %s = %s", name, value));
        }
        super.setPropertyValue(name, value);
    }

    @Override
    public void setString(String name, String value) throws DocumentException {
        if (this.isReadOnlyProperty(name)) {
            throw new VersionNotModifiableException();
        }
        super.setString(name, value);
    }

    @Override
    public void setBoolean(String name, boolean value) throws DocumentException {
        if (this.isReadOnlyProperty(name)) {
            throw new VersionNotModifiableException();
        }
        super.setBoolean(name, value);
    }

    @Override
    public void setLong(String name, long value) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void setDouble(String name, double value) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void setDate(String name, Calendar value) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void setContent(String name, Blob value) {
        throw new VersionNotModifiableException();
    }

    @Override
    public void removeProperty(String name) {
        throw new VersionNotModifiableException();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.equals((SQLDocumentVersion)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentVersion other) {
        return this.getNode().equals((Object)other.getNode());
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }

    public static class VersionNotModifiableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public VersionNotModifiableException() {
        }

        public VersionNotModifiableException(String message) {
            super(message);
        }
    }
}

