/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBaseProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;

public class SQLSimpleProperty
extends SQLBaseProperty {
    private final SimpleProperty property;

    public SQLSimpleProperty(SimpleProperty property, Type type, SQLDocument doc) {
        super(type, property.getName(), doc);
        this.property = property;
    }

    public String getName() {
        return this.property.getName();
    }

    public Serializable getValue() throws DocumentException {
        try {
            return this.property.getValue();
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }

    public void setValue(Object value) throws DocumentException {
        this.checkWritable();
        if (value != null && !(value instanceof Serializable)) {
            throw new DocumentException("Value is not Serializable: " + value);
        }
        try {
            this.property.setValue((Serializable)value);
        }
        catch (StorageException e) {
            throw new DocumentException((Throwable)((Object)e));
        }
    }
}

