/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import org.nuxeo.common.utils.FileNamePattern;
import org.nuxeo.common.utils.Path;

public class FilePathPattern {
    private final FileNamePattern[] patterns;

    public FilePathPattern(String path) {
        this(new Path(path));
    }

    public FilePathPattern(Path path) {
        String[] segments = path.segments();
        this.patterns = new FileNamePattern[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            this.patterns[i] = segment.equals("**") ? null : new FileNamePattern(segment);
        }
    }

    public boolean match(String text) {
        return this.match(new Path(text));
    }

    public boolean match(Path path) {
        int k = 0;
        String[] segments = path.segments();
        block0: for (int i = 0; i < segments.length; ++i) {
            if (k == this.patterns.length) {
                return false;
            }
            FileNamePattern pattern = this.patterns[k];
            if (pattern == null) {
                if (++k == this.patterns.length) {
                    return true;
                }
                pattern = this.patterns[k];
                while (i < segments.length) {
                    if (pattern.match(segments[i])) {
                        ++k;
                        continue block0;
                    }
                    ++i;
                }
                return false;
            }
            if (!pattern.match(segments[i])) {
                return false;
            }
            ++k;
        }
        if (k < this.patterns.length) {
            return this.patterns.length == k + 1 && this.patterns[k] == null;
        }
        return true;
    }
}

