/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.automation.core.trace.Trace;

public class Call {
    protected final String chainId;
    protected final OperationType type;
    protected final InvokableMethod method;
    protected final Map<String, Object> parameters;
    protected final Map<String, Object> variables;
    protected final List<Trace> nested = new LinkedList<Trace>();
    protected final Object input;

    public Call(OperationType chain, OperationContext context, OperationType type, InvokableMethod method, Map<String, Object> parms) {
        this.type = type;
        this.variables = context != null ? new HashMap<String, Object>(context) : null;
        this.method = method;
        this.input = context != null ? context.getInput() : null;
        this.parameters = parms;
        this.chainId = chain != null ? chain.getId() : "No bound to a chain";
    }

    public OperationType getType() {
        return this.type;
    }

    public InvokableMethod getMethod() {
        return this.method;
    }

    public Map<String, Object> getParmeters() {
        return this.parameters;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Object getInput() {
        return this.input;
    }

    public List<Trace> getNested() {
        return this.nested;
    }

    public String getChainId() {
        return this.chainId;
    }
}

