/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor.views;

import java.util.Properties;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.rendering.RenderingInfo;

public class AreaStyleToolbox {
    public static String render(RenderingInfo info) {
        Style style = (Style)ElementFormatter.getFormatFor((Element)info.getElement(), (String)"style");
        Properties properties = null;
        if (style != null) {
            String viewName = info.getFormat().getName();
            properties = style.getPropertiesFor(viewName, "");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<table class=\"toolbox\"><tr>");
        sb.append(AreaStyleToolbox.renderIcon(properties, "background", "background", "areaStyleBackground"));
        sb.append(AreaStyleToolbox.renderIcon(properties, "border-left", "left border", "areaStyleBorderLeft"));
        sb.append(AreaStyleToolbox.renderIcon(properties, "border-top", "top border", "areaStyleBorderTop"));
        sb.append(AreaStyleToolbox.renderIcon(properties, "border-bottom", "bottom border", "areaStyleBorderBottom"));
        sb.append(AreaStyleToolbox.renderIcon(properties, "border-right", "right border", "areaStyleBorderRight"));
        sb.append("</tr></table>");
        return sb.toString();
    }

    private static String renderIcon(Properties properties, String name, String title, String iconClassName) {
        String className = "picker";
        if (properties != null && properties.getProperty(name) != null) {
            className = "picker selected";
        }
        return String.format("<td><div class=\"%s %s\" name=\"%s\" title=\"%s\"></div></td>", className, iconClassName, name, title);
    }
}

