/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.localconfiguration.simple.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.platform.localconfiguration.simple.SimpleConfiguration;

@Operation(id="LocalConfiguration.PutSimpleConfigurationParameter", category="Local Configuration", label="Put a Simple Configuration Parameter", description="Put a Simple Configuration parameter on the input document. Add the 'SimpleConfiguration' facet on the input document if needed. The user adding a parameter must have WRITE access on the input document")
public class PutSimpleConfigurationParameter {
    public static final String ID = "LocalConfiguration.PutSimpleConfigurationParameter";
    @Context
    protected CoreSession session;
    @Context
    protected LocalConfigurationService localConfigurationService;
    @Param(name="key")
    protected String key;
    @Param(name="value")
    protected String value;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (!doc.hasFacet("SimpleConfiguration")) {
            doc.addFacet("SimpleConfiguration");
            doc = this.session.saveDocument(doc);
        }
        SimpleConfiguration simpleConfiguration = (SimpleConfiguration)this.localConfigurationService.getConfiguration(SimpleConfiguration.class, "SimpleConfiguration", doc);
        simpleConfiguration.put(this.key, this.value);
        simpleConfiguration.save(this.session);
        if (this.save) {
            doc = this.session.saveDocument(doc);
        }
        return doc;
    }
}

