/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.fm;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.wss.MSWSSConsts;
import org.nuxeo.wss.WSSConfig;
import org.nuxeo.wss.fm.PluggableTemplareLoader;
import org.nuxeo.wss.fprpc.FPRPCConts;

public class FreeMarkerRenderer {
    protected Configuration fmConfig = new Configuration();
    protected static FreeMarkerRenderer instance;
    protected static ClassTemplateLoader addLoader;
    protected PluggableTemplareLoader loader;
    public static final String FM_TEMPLATE_PATH;
    private static final Log log;

    public static FreeMarkerRenderer instance() {
        if (instance == null) {
            instance = new FreeMarkerRenderer();
        }
        return instance;
    }

    protected TemplateLoader getLoader() {
        if (this.loader == null) {
            ClassTemplateLoader defaultLoader = new ClassTemplateLoader(this.getClass(), FM_TEMPLATE_PATH);
            this.loader = new PluggableTemplareLoader(defaultLoader);
            if (addLoader != null) {
                this.loader.setAdditionnalLoader(addLoader);
            }
        }
        return this.loader;
    }

    public static void addLoader(Class klass) {
        FreeMarkerRenderer.addLoader(klass, null);
    }

    public static void addLoader(Class klass, String path) {
        if (path == null) {
            path = FM_TEMPLATE_PATH;
        }
        addLoader = new ClassTemplateLoader(klass, path);
        instance = null;
    }

    public FreeMarkerRenderer() {
        this.fmConfig.setWhitespaceStripping(true);
        this.fmConfig.setLocalizedLookup(false);
        this.fmConfig.setClassicCompatible(true);
        this.fmConfig.setNumberFormat("0.######");
        try {
            this.fmConfig.setSharedVariable("config", (Object)WSSConfig.instance());
            this.fmConfig.setSharedVariable("MSWSSConsts", (Object)new MSWSSConsts());
            this.fmConfig.setSharedVariable("FPRPCConts", (Object)new FPRPCConts());
        }
        catch (TemplateModelException e) {
            log.error((Object)"Error creating FreeMarker engine", (Throwable)e);
        }
        this.fmConfig.setTemplateLoader(this.getLoader());
    }

    public void render(String templateName, Map<String, Object> params, Writer writer) throws Exception {
        Template template = this.fmConfig.getTemplate(templateName);
        Environment env = template.createProcessingEnvironment(params, writer);
        env.process();
    }

    static {
        FM_TEMPLATE_PATH = File.separator + "templates" + File.separator;
        log = LogFactory.getLog(FreeMarkerRenderer.class);
    }
}

