/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.email;

import com.phloc.commons.regex.RegExPool;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EmailAddressUtils {
    public static final String EMAIL_ADDRESS_PATTERN = "[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
    private static final Pattern s_aPattern = RegExPool.getPattern("[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?");

    private EmailAddressUtils() {
    }

    @Nullable
    public static String getUnifiedEmailAddress(@Nullable String string) {
        return string == null ? null : string.trim().toLowerCase(Locale.US);
    }

    public static boolean isValid(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = EmailAddressUtils.getUnifiedEmailAddress(string);
        return s_aPattern.matcher(string2).matches();
    }
}

