/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.iterate;

import com.phloc.commons.combine.CombinatorStringWithSeparatorIgnoreNull;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.file.filter.FileFilterFileFromFilenameFilter;
import com.phloc.commons.tree.withid.folder.DefaultFolderTree;
import com.phloc.commons.tree.withid.folder.DefaultFolderTreeItem;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemFolderTree
extends DefaultFolderTree<String, File, List<File>> {
    private static void _iterate(@Nonnull DefaultFolderTreeItem<String, File, List<File>> defaultFolderTreeItem, @Nonnull File file, @Nullable FileFilter fileFilter, @Nullable FileFilter fileFilter2) {
        if (file != null) {
            for (File file2 : FileUtils.getDirectoryContent(file)) {
                if (file2.isFile()) {
                    if (fileFilter2 != null && !fileFilter2.accept(file2)) continue;
                    ((List)defaultFolderTreeItem.getData()).add(file2);
                    continue;
                }
                if (!file2.isDirectory() || FilenameHelper.isSystemInternalDirectory(file2) || fileFilter != null && !fileFilter.accept(file2)) continue;
                DefaultFolderTreeItem defaultFolderTreeItem2 = (DefaultFolderTreeItem)defaultFolderTreeItem.createChildItem(file2.getName(), (File)((Object)new ArrayList()));
                FileSystemFolderTree._iterate(defaultFolderTreeItem2, file2, fileFilter, fileFilter2);
            }
        }
    }

    public FileSystemFolderTree(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemFolderTree(@Nonnull File file) {
        this(file, (FileFilter)null, (FileFilter)null);
    }

    public FileSystemFolderTree(@Nonnull String string, @Nullable FilenameFilter filenameFilter, @Nullable FilenameFilter filenameFilter2) {
        this(new File(string), filenameFilter, filenameFilter2);
    }

    public FileSystemFolderTree(@Nonnull String string, @Nullable FileFilter fileFilter, @Nullable FileFilter fileFilter2) {
        this(new File(string), fileFilter, fileFilter2);
    }

    public FileSystemFolderTree(@Nonnull File file, @Nullable FilenameFilter filenameFilter, @Nullable FilenameFilter filenameFilter2) {
        this(file, (FileFilter)(filenameFilter == null ? null : new FileFilterFileFromFilenameFilter(filenameFilter)), (FileFilter)(filenameFilter2 == null ? null : new FileFilterFileFromFilenameFilter(filenameFilter2)));
    }

    public FileSystemFolderTree(@Nonnull File file, @Nullable FileFilter fileFilter, @Nullable FileFilter fileFilter2) {
        super(new CombinatorStringWithSeparatorIgnoreNull("/"));
        if (file == null) {
            throw new NullPointerException("startDir");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Start directory is not a directory!");
        }
        DefaultFolderTreeItem defaultFolderTreeItem = (DefaultFolderTreeItem)((DefaultFolderTreeItem)this.getRootItem()).createChildItem(file.getName(), new ArrayList());
        FileSystemFolderTree._iterate(defaultFolderTreeItem, file, fileFilter, fileFilter2);
    }
}

