/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.math;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.callback.INonThrowingRunnableWithParameter;
import com.phloc.commons.math.CombinationGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CombinationGeneratorFlexible<DATATYPE> {
    private final boolean m_bAllowEmpty;
    private final int m_nSlotCount;

    public CombinationGeneratorFlexible(@Nonnegative int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("Passed slot count is too small: " + n);
        }
        this.m_nSlotCount = n;
        this.m_bAllowEmpty = bl;
    }

    public void iterateAllCombinations(@Nonnull List<DATATYPE> list, @Nonnull INonThrowingRunnableWithParameter<List<DATATYPE>> iNonThrowingRunnableWithParameter) {
        int n;
        if (list == null) {
            throw new NullPointerException("elements");
        }
        if (iNonThrowingRunnableWithParameter == null) {
            throw new NullPointerException("callback");
        }
        int n2 = n = this.m_bAllowEmpty ? 0 : 1;
        while (n <= this.m_nSlotCount) {
            if (list.isEmpty()) {
                iNonThrowingRunnableWithParameter.run(new ArrayList());
            } else {
                for (List<DATATYPE> list2 : new CombinationGenerator<DATATYPE>(list, n)) {
                    iNonThrowingRunnableWithParameter.run(list2);
                }
            }
            ++n;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<List<DATATYPE>> getCombinations(@Nonnull List<DATATYPE> list) {
        if (list == null) {
            throw new NullPointerException("elements");
        }
        final HashSet<List<DATATYPE>> hashSet = new HashSet<List<DATATYPE>>();
        this.iterateAllCombinations(list, new INonThrowingRunnableWithParameter<List<DATATYPE>>(){

            @Override
            public void run(List<DATATYPE> list) {
                hashSet.add(list);
            }
        });
        return hashSet;
    }

    public static <DATATYPE> void iterateAllCombinations(@Nonnull List<DATATYPE> list, boolean bl, @Nonnull INonThrowingRunnableWithParameter<List<DATATYPE>> iNonThrowingRunnableWithParameter) {
        new CombinationGeneratorFlexible<DATATYPE>(list.size(), bl).iterateAllCombinations(list, iNonThrowingRunnableWithParameter);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <DATATYPE> Set<List<DATATYPE>> getCombinations(@Nonnull List<DATATYPE> list, boolean bl) {
        return new CombinationGeneratorFlexible<DATATYPE>(list.size(), bl).getCombinations(list);
    }
}

