/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.thirdparty;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.thirdparty.ILicense;
import com.phloc.commons.version.Version;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CustomLicense
implements ILicense {
    private final String m_sID;
    private final String m_sName;
    private final Version m_aVersion;
    private final String m_sWebSiteURL;

    public CustomLicense(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable Version version, @Nullable String string3) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("ID");
        }
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("name");
        }
        this.m_sID = string;
        this.m_sName = string2;
        this.m_aVersion = version;
        this.m_sWebSiteURL = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    @Nullable
    public String getURL() {
        return this.m_sWebSiteURL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CustomLicense)) {
            return false;
        }
        CustomLicense customLicense = (CustomLicense)object;
        return this.m_sID.equals(customLicense.m_sID) && this.m_sName.equals(customLicense.m_sName) && EqualsUtils.equals(this.m_aVersion, customLicense.m_aVersion) && EqualsUtils.equals(this.m_sWebSiteURL, customLicense.m_sWebSiteURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_sName).append(this.m_aVersion).append(this.m_sWebSiteURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("name", this.m_sName).appendIfNotNull("version", this.m_aVersion).appendIfNotNull("website", this.m_sWebSiteURL).toString();
    }
}

