/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.hash.HashCodeGenerator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.AbstractCharCollection;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.CharList;
import org.apache.commons.collections.primitives.CharListIterator;

public abstract class RandomAccessCharList
extends AbstractCharCollection
implements CharList {
    private int _modCount = 0;

    protected RandomAccessCharList() {
    }

    @Override
    public abstract char get(int var1);

    @Override
    public abstract int size();

    @Override
    public char removeElementAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char set(int n, char c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, char c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(char c) {
        this.add(this.size(), c);
        return true;
    }

    @Override
    public boolean addAll(int n, @Nonnull CharCollection charCollection) {
        int n2 = n;
        boolean bl = false;
        CharIterator charIterator = charCollection.iterator();
        while (charIterator.hasNext()) {
            this.add(n2++, charIterator.next());
            bl = true;
        }
        return bl;
    }

    @Override
    public int indexOf(char c) {
        int n = 0;
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            if (charIterator.next() == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char c) {
        CharListIterator charListIterator = this.listIterator(this.size());
        while (charListIterator.hasPrevious()) {
            if (charListIterator.previous() != c) continue;
            return charListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public CharIterator iterator() {
        return this.listIterator();
    }

    @Override
    public CharListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public CharListIterator listIterator(int n) {
        return new RandomAccessCharacterListIterator(this, n);
    }

    @Override
    public CharList subList(int n, int n2) {
        return new RandomAccessCharacterSubList(this, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharList)) {
            return false;
        }
        CharList charList = (CharList)object;
        if (this.size() != charList.size()) {
            return false;
        }
        CharIterator charIterator = charList.iterator();
        CharIterator charIterator2 = this.iterator();
        while (charIterator2.hasNext()) {
            if (charIterator2.next() == charIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            hashCodeGenerator.append(charIterator.next());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            stringBuilder.append(charIterator.next());
            if (!charIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessCharacterSubList
    extends RandomAccessCharList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessCharList _list = null;
        private ComodChecker _comod = null;

        RandomAccessCharacterSubList(RandomAccessCharList randomAccessCharList, int n, int n2) {
            if (n < 0 || n2 > randomAccessCharList.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this._list = randomAccessCharList;
            this._offset = n;
            this._limit = n2 - n;
            this._comod = new ComodChecker(randomAccessCharList);
            this._comod.resyncModCount();
        }

        @Override
        public char get(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(n));
        }

        @Override
        public char removeElementAt(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            char c = this._list.removeElementAt(this.toUnderlyingIndex(n));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return c;
        }

        @Override
        public char set(int n, char c) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            char c2 = this._list.set(this.toUnderlyingIndex(n), c);
            this.incrModCount();
            this._comod.resyncModCount();
            return c2;
        }

        @Override
        public void add(int n, char c) {
            this.checkRangeIncludingEndpoint(n);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(n), c);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int n) {
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int n) {
            return n + this._offset;
        }
    }

    protected static class RandomAccessCharacterListIterator
    extends ComodChecker
    implements CharListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessCharacterListIterator(RandomAccessCharList randomAccessCharList, int n) {
            super(randomAccessCharList);
            if (n < 0 || n > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + n + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = n;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public char next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char c = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return c;
        }

        @Override
        public char previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            char c = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return c;
        }

        @Override
        public void add(char c) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, c);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (this._lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this._lastReturnedIndex == this._nextIndex) {
                this.getList().removeElementAt(this._lastReturnedIndex);
            } else {
                this.getList().removeElementAt(this._lastReturnedIndex);
                --this._nextIndex;
            }
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void set(char c) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, c);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessCharList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessCharList randomAccessCharList) {
            this._source = randomAccessCharList;
            this.resyncModCount();
        }

        protected RandomAccessCharList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

