/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleList;
import org.apache.commons.collections.primitives.adapters.AbstractDoubleCollectionCollection;
import org.apache.commons.collections.primitives.adapters.CollectionDoubleCollection;
import org.apache.commons.collections.primitives.adapters.DoubleListIteratorListIterator;
import org.apache.commons.collections.primitives.adapters.DoubleListList;

abstract class AbstractDoubleListList
extends AbstractDoubleCollectionCollection
implements List<Double> {
    AbstractDoubleListList() {
    }

    @Nonnull
    protected abstract DoubleList getDoubleList();

    @Override
    @Nonnull
    protected final DoubleCollection getDoubleCollection() {
        return this.getDoubleList();
    }

    @Override
    public void add(int n, @Nonnull Double d) {
        this.getDoubleList().add(n, d);
    }

    @Override
    public boolean addAll(int n, Collection<? extends Double> collection) {
        return this.getDoubleList().addAll(n, CollectionDoubleCollection.wrap(collection));
    }

    @Override
    @Nonnull
    public Double get(int n) {
        return this.getDoubleList().get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.getDoubleList().indexOf((Double)object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getDoubleList().lastIndexOf((Double)object);
    }

    @Override
    public ListIterator<Double> listIterator() {
        return DoubleListIteratorListIterator.wrap(this.getDoubleList().listIterator());
    }

    @Override
    public ListIterator<Double> listIterator(int n) {
        return DoubleListIteratorListIterator.wrap(this.getDoubleList().listIterator(n));
    }

    @Override
    @Nonnull
    public Double remove(int n) {
        return this.getDoubleList().removeElementAt(n);
    }

    @Override
    @Nonnull
    public Double set(int n, Double d) {
        return this.getDoubleList().set(n, d);
    }

    @Override
    public List<Double> subList(int n, int n2) {
        return DoubleListList.wrap(this.getDoubleList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator<Double> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            Double d = iterator.next();
            Object e = iterator2.next();
            if (!(null == d ? null != e : !((Object)d).equals(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getDoubleList()).hashCode();
    }
}

