/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongIterator;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.LongListIterator;
import org.apache.commons.collections.primitives.adapters.AbstractCollectionLongCollection;
import org.apache.commons.collections.primitives.adapters.ListIteratorLongListIterator;
import org.apache.commons.collections.primitives.adapters.ListLongList;
import org.apache.commons.collections.primitives.adapters.LongCollectionCollection;

abstract class AbstractListLongList
extends AbstractCollectionLongCollection
implements LongList {
    AbstractListLongList() {
    }

    @Override
    @Nonnull
    protected final Collection<Long> getCollection() {
        return this.getList();
    }

    @Nonnull
    protected abstract List<Long> getList();

    @Override
    public void add(int n, long l) {
        this.getList().add(n, l);
    }

    @Override
    public boolean addAll(int n, @Nonnull LongCollection longCollection) {
        return this.getList().addAll(n, LongCollectionCollection.wrap(longCollection));
    }

    @Override
    public long get(int n) {
        return this.getList().get(n);
    }

    @Override
    public int indexOf(long l) {
        return this.getList().indexOf(l);
    }

    @Override
    public int lastIndexOf(long l) {
        return this.getList().lastIndexOf(l);
    }

    @Override
    @Nonnull
    public LongListIterator listIterator() {
        return ListIteratorLongListIterator.wrap(this.getList().listIterator());
    }

    @Override
    @Nonnull
    public LongListIterator listIterator(int n) {
        return ListIteratorLongListIterator.wrap(this.getList().listIterator(n));
    }

    @Override
    public long removeElementAt(int n) {
        return this.getList().remove(n);
    }

    @Override
    public long set(int n, long l) {
        return this.getList().set(n, l);
    }

    @Override
    @Nonnull
    public LongList subList(int n, int n2) {
        return ListLongList.wrap(this.getList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongList)) {
            return false;
        }
        LongList longList = (LongList)object;
        if (this.size() != longList.size()) {
            return false;
        }
        LongIterator longIterator = this.iterator();
        LongIterator longIterator2 = longList.iterator();
        while (longIterator.hasNext()) {
            if (longIterator.next() == longIterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }
}

