/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortList;
import org.apache.commons.collections.primitives.adapters.AbstractShortCollectionCollection;
import org.apache.commons.collections.primitives.adapters.CollectionShortCollection;
import org.apache.commons.collections.primitives.adapters.ShortListIteratorListIterator;
import org.apache.commons.collections.primitives.adapters.ShortListList;

abstract class AbstractShortListList
extends AbstractShortCollectionCollection
implements List<Short> {
    AbstractShortListList() {
    }

    @Nonnull
    protected abstract ShortList getShortList();

    @Override
    @Nonnull
    protected final ShortCollection getShortCollection() {
        return this.getShortList();
    }

    @Override
    public void add(int n, @Nonnull Short s) {
        this.getShortList().add(n, s);
    }

    @Override
    public boolean addAll(int n, Collection<? extends Short> collection) {
        return this.getShortList().addAll(n, CollectionShortCollection.wrap(collection));
    }

    @Override
    @Nonnull
    public Short get(int n) {
        return this.getShortList().get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.getShortList().indexOf((Short)object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getShortList().lastIndexOf((Short)object);
    }

    @Override
    public ListIterator<Short> listIterator() {
        return ShortListIteratorListIterator.wrap(this.getShortList().listIterator());
    }

    @Override
    public ListIterator<Short> listIterator(int n) {
        return ShortListIteratorListIterator.wrap(this.getShortList().listIterator(n));
    }

    @Override
    @Nonnull
    public Short remove(int n) {
        return this.getShortList().removeElementAt(n);
    }

    @Override
    @Nonnull
    public Short set(int n, Short s) {
        return this.getShortList().set(n, s);
    }

    @Override
    public List<Short> subList(int n, int n2) {
        return ShortListList.wrap(this.getShortList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator<Short> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            Short s = iterator.next();
            Object e = iterator2.next();
            if (!(null == s ? null != e : !((Object)s).equals(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getShortList()).hashCode();
    }
}

