/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisClusterMaxRedirectionsException;
import redis.clients.jedis.exceptions.JedisRedirectionException;
import redis.clients.util.JedisClusterCRC16;

public abstract class JedisClusterCommand<T> {
    private boolean asking = false;
    private JedisClusterConnectionHandler connectionHandler;
    private int commandTimeout;
    private int redirections;

    public JedisClusterCommand(JedisClusterConnectionHandler connectionHandler, int timeout, int maxRedirections) {
        this.connectionHandler = connectionHandler;
        this.commandTimeout = timeout;
        this.redirections = maxRedirections;
    }

    public abstract T execute();

    public T run(String key) {
        try {
            if (key == null) {
                throw new JedisClusterException("No way to dispatch this command to Redis Cluster.");
            }
            if (this.redirections == 0) {
                throw new JedisClusterMaxRedirectionsException("Too many Cluster redirections?");
            }
            this.connectionHandler.getConnectionFromSlot(JedisClusterCRC16.getSlot(key));
            if (this.asking) {
                this.connectionHandler.getConnection().asking();
            }
            return this.execute();
        }
        catch (JedisRedirectionException jre) {
            return this.handleRedirection(jre, key);
        }
    }

    private T handleRedirection(JedisRedirectionException jre, String key) {
        if (jre instanceof JedisAskDataException) {
            this.asking = true;
        }
        --this.redirections;
        this.connectionHandler.assignSlotToNode(jre.getSlot(), jre.getTargetNode());
        return this.run(key);
    }
}

