/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.CacheHeaderContentStream;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;

public class NuxeoContentStream
implements CacheHeaderContentStream {
    protected final Blob blob;

    public NuxeoContentStream(Blob blob) {
        this.blob = blob;
    }

    public long getLength() {
        return this.blob.getLength();
    }

    public BigInteger getBigLength() {
        return BigInteger.valueOf(this.blob.getLength());
    }

    public String getMimeType() {
        return this.blob.getMimeType();
    }

    public String getFileName() {
        return this.blob.getFilename();
    }

    public InputStream getStream() {
        try {
            return this.blob.getStream();
        }
        catch (IOException e) {
            throw new CmisRuntimeException("Failed to get stream", (Throwable)e);
        }
    }

    public List<CmisExtensionElement> getExtensions() {
        return null;
    }

    public void setExtensions(List<CmisExtensionElement> extensions) {
        throw new UnsupportedOperationException();
    }

    public String getCacheControl() {
        return null;
    }

    public String getETag() {
        if (this.blob instanceof SQLBlob) {
            return ((SQLBlob)this.blob).getBinary().getDigest();
        }
        return null;
    }

    public GregorianCalendar getExpires() {
        return null;
    }
}

