/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoRepositories
extends DefaultComponent {
    protected static Map<String, NuxeoRepository> repositories;

    public void deactivate(ComponentContext context) throws Exception {
        NuxeoRepositories.clear();
    }

    public static void clear() {
        repositories = null;
    }

    public static NuxeoRepository getRepository(String repositoryId) {
        if (repositories == null) {
            NuxeoRepositories.initRepositories();
        }
        return repositories.get(repositoryId);
    }

    public static List<NuxeoRepository> getRepositories() {
        if (repositories == null) {
            NuxeoRepositories.initRepositories();
        }
        return new ArrayList<NuxeoRepository>(repositories.values());
    }

    protected static void initRepositories() {
        repositories = Collections.synchronizedMap(new HashMap());
        try {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
            for (Repository repo : repositoryManager.getRepositories()) {
                String rootFolderId;
                String repositoryId = repo.getName();
                CoreSession coreSession = null;
                try {
                    coreSession = repositoryManager.getRepository(repositoryId).open();
                    rootFolderId = coreSession.getRootDocument().getId();
                }
                catch (ClientException e) {
                    throw new CmisRuntimeException(e.toString(), (Throwable)e);
                }
                finally {
                    if (coreSession != null) {
                        Repository.close((CoreSession)coreSession);
                    }
                }
                repositories.put(repositoryId, new NuxeoRepository(repositoryId, rootFolderId));
            }
        }
        catch (CmisRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }
}

