/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.ui.web.auth.digest;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;

public class DigestAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final Log log = LogFactory.getLog(DigestAuthenticator.class);
    protected static final String DEFAULT_REALMNAME = "NUXEO";
    protected static final long DEFAULT_NONCE_VALIDITY_SECONDS = 1000L;
    protected static final Pattern PAIR_ITEM_PATTERN = Pattern.compile("^(.*?)=([\\s\"]*)?(.*)(\")?$");
    protected static final String REALM_NAME_KEY = "RealmName";
    protected static final String BA_HEADER_NAME = "WWW-Authenticate";
    protected String realmName;
    protected long nonceValiditySeconds = 1000L;
    protected String accessKey = "key";

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        long expiryTime = System.currentTimeMillis() + this.nonceValiditySeconds * 1000L;
        String signature = DigestUtils.md5Hex((String)(expiryTime + ":" + this.accessKey));
        String nonce = expiryTime + ":" + signature;
        String nonceB64 = new String(Base64.encodeBase64((byte[])nonce.getBytes()));
        String authenticateHeader = String.format("Digest realm=\"%s\", qop=\"auth\", nonce=\"%s\"", this.realmName, nonceB64);
        try {
            httpResponse.addHeader(BA_HEADER_NAME, authenticateHeader);
            httpResponse.sendError(401);
            return Boolean.TRUE;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String header = httpRequest.getHeader("Authorization");
        String DIGEST_PREFIX = "digest ";
        if (StringUtils.isEmpty((String)header) || !header.toLowerCase().startsWith(DIGEST_PREFIX)) {
            return null;
        }
        Map<String, String> headerMap = DigestAuthenticator.splitParameters(header.substring(DIGEST_PREFIX.length()));
        headerMap.put("httpMethod", httpRequest.getMethod());
        String nonceB64 = headerMap.get("nonce");
        String nonce = new String(Base64.decodeBase64((byte[])nonceB64.getBytes()));
        String[] nonceTokens = nonce.split(":");
        long nonceExpiryTime = Long.parseLong(nonceTokens[0]);
        String username = headerMap.get("username");
        String responseDigest = headerMap.get("response");
        UserIdentificationInfo userIdent = new UserIdentificationInfo(username, responseDigest);
        userIdent.setLoginParameters(headerMap);
        return userIdent;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return Boolean.TRUE;
    }

    public void initPlugin(Map<String, String> parameters) {
        this.realmName = parameters.containsKey(REALM_NAME_KEY) ? parameters.get(REALM_NAME_KEY) : DEFAULT_REALMNAME;
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> splitParameters(String auth) {
        HashMap<String, String> map = new HashMap<String, String>();
        CSVReader reader = null;
        try {
            reader = new CSVReader((Reader)new StringReader(auth));
            String[] array = null;
            try {
                array = reader.readNext();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                HashMap<String, String> hashMap = map;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        log.error((Object)"Could not close reader", (Throwable)ioe);
                    }
                }
                return hashMap;
            }
            for (String itemPairStr : array) {
                Matcher match = PAIR_ITEM_PATTERN.matcher(itemPairStr);
                if (match.find()) {
                    String key = match.group(1);
                    String value = match.group(3);
                    map.put(key.trim(), value.trim());
                    continue;
                }
                log.warn((Object)("Could not parse item pair " + itemPairStr));
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    log.error((Object)"Could not close reader", (Throwable)ioe);
                }
            }
        }
        return map;
    }
}

