/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;

public class EncryptionKey {
    private EncryptionType keyType;
    private byte[] keyValue;
    private int keyVersion;

    public EncryptionKey(EncryptionType keyType, byte[] keyValue) {
        this.keyType = keyType;
        this.keyValue = keyValue;
    }

    public EncryptionKey(EncryptionType keyType, byte[] keyValue, int keyVersion) {
        this.keyType = keyType;
        this.keyValue = keyValue;
        this.keyVersion = keyVersion;
    }

    public synchronized void destroy() {
        if (this.keyValue != null) {
            for (int ii = 0; ii < this.keyValue.length; ++ii) {
                this.keyValue[ii] = 0;
            }
        }
    }

    public EncryptionType getKeyType() {
        return this.keyType;
    }

    public byte[] getKeyValue() {
        return this.keyValue;
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey that = (EncryptionKey)o;
        return this.keyType == that.keyType && Arrays.equals(this.keyValue, that.keyValue);
    }

    public String toString() {
        return this.keyType.toString() + " (" + this.keyType.getOrdinal() + ")";
    }
}

