/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.nuxeo.ecm.core.work.WorkHolder;

public class NuxeoBlockingQueue<T>
extends LinkedBlockingQueue<T> {
    private static final long serialVersionUID = 1L;
    private final ReentrantLock limitedPutLock = new ReentrantLock();
    private final int limitedCapacity;
    private final Set<String> workIds;

    public NuxeoBlockingQueue(int capacity) {
        super(capacity < 0 ? Integer.MAX_VALUE : 2 * capacity);
        this.limitedCapacity = capacity;
        this.workIds = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsWorkId(String workId) {
        Set<String> set = this.workIds;
        synchronized (set) {
            return this.workIds.contains(workId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T addWorkId(T e) {
        if (e instanceof WorkHolder) {
            WorkHolder wh = (WorkHolder)e;
            String id = WorkHolder.getWork(wh).getId();
            Set<String> set = this.workIds;
            synchronized (set) {
                this.workIds.add(id);
            }
        }
        return e;
    }

    private boolean addWorkId(T e, boolean added) {
        if (added) {
            this.addWorkId(e);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T removeWorkId(T e) {
        if (e instanceof WorkHolder) {
            WorkHolder wh = (WorkHolder)e;
            String id = WorkHolder.getWork(wh).getId();
            Set<String> set = this.workIds;
            synchronized (set) {
                this.workIds.remove(id);
            }
        }
        return e;
    }

    private boolean removeWorkId(T e, boolean removed) {
        if (removed) {
            this.removeWorkId(e);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearWorkIds() {
        Set<String> set = this.workIds;
        synchronized (set) {
            this.workIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void limitedPut(T e) throws InterruptedException {
        this.limitedPutLock.lockInterruptibly();
        try {
            while (this.remainingCapacity() < this.limitedCapacity) {
                Thread.sleep(100L);
            }
            this.put(e);
        }
        finally {
            this.limitedPutLock.unlock();
        }
    }

    @Override
    public boolean offer(T e) {
        if (this.limitedCapacity < 0) {
            return this.addWorkId(e, super.offer(e));
        }
        try {
            if (Thread.currentThread().getName().startsWith("Nuxeo-Work-")) {
                this.put(e);
            } else {
                this.limitedPut(e);
            }
            return true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", ie);
        }
    }

    @Override
    public T remove() {
        return (T)this.removeWorkId(super.remove());
    }

    @Override
    public T poll() {
        return (T)this.removeWorkId(super.poll());
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr(super.iterator());
    }

    @Override
    public void clear() {
        super.clear();
        this.clearWorkIds();
    }

    @Override
    public boolean add(T e) {
        return this.addWorkId(e, super.add(e));
    }

    @Override
    public void put(T e) throws InterruptedException {
        super.put(e);
        this.addWorkId(e);
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.addWorkId(e, super.offer(e, timeout, unit));
    }

    @Override
    public T take() throws InterruptedException {
        return (T)this.removeWorkId(super.take());
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (T)this.removeWorkId(super.poll(timeout, unit));
    }

    @Override
    public boolean remove(Object o) {
        return this.removeWorkId(o, super.remove(o));
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        this.clearWorkIds();
        return super.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        LinkedList tmp = new LinkedList();
        int n = super.drainTo(tmp, maxElements);
        c.addAll(tmp);
        for (Object e : tmp) {
            this.removeWorkId(e);
        }
        return n;
    }

    private class Itr
    implements Iterator<T> {
        private Iterator<T> it;
        private T last;

        public Itr(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            this.it.remove();
            NuxeoBlockingQueue.this.removeWorkId(this.last);
        }
    }
}

