/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class HttpMessage {
    String httpVersion = null;
    static final String CRLF = "\r\n";
    static final String[] KNOWN_HEADERS = new String[]{"Content-Length", "Content-Type", "Date", "Connection", "WWW-Authenticate", "Authorization"};
    static final int CONTENT_LENGTH_HEADER = 0;
    static final int CONTENT_TYPE_HEADER = 1;
    static final int DATE_HEADER = 2;
    static final int CONNECTION_HEADER = 3;
    static final int WWW_AUTHENTICATE_HEADER = 4;
    static final int AUTHORIZATION_HEADER = 5;
    private String[] headers = new String[KNOWN_HEADERS.length];
    private HttpBody body;

    HttpMessage(HttpBody body) {
        if (body == null) {
            throw new IllegalArgumentException("HttpBody cannot be null");
        }
        this.body = body;
        this.setContentLength();
    }

    boolean hasKeepAliveFlag() {
        String connection = this.getHeader(3);
        if (connection == null) {
            return false;
        }
        return connection.toLowerCase().equals("keep-alive");
    }

    abstract void readFrom(InputStream var1) throws IOException, MalformedHttpException;

    abstract void writeTo(OutputStream var1) throws IOException;

    void setHeader(int headerNumber, String value) {
        this.headers[headerNumber] = value;
    }

    String getHeader(int headerNumber) {
        return this.headers[headerNumber];
    }

    void writeHeadersAndBodyTo(OutputStream s, String firstLine) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(firstLine).append(CRLF);
        int i = 0;
        while (i < KNOWN_HEADERS.length) {
            String header = this.getHeader(i);
            if (header != null) {
                buffer.append(KNOWN_HEADERS[i]).append(": ").append(header).append(CRLF);
            }
            ++i;
        }
        buffer.append(CRLF);
        s.write(buffer.toString().getBytes());
        this.body.writeTo(s);
    }

    void readBodyFrom(InputStream s, int contentLength) throws IOException {
        this.body.readFrom(s, contentLength);
        this.setContentLength();
    }

    int getContentLength() {
        return this.body.getByteCount();
    }

    byte[] getContentBytes() {
        return this.body.getBytes();
    }

    private void setContentLength() {
        int contentLength = this.body.getByteCount();
        String contentLengthString = contentLength > 0 ? Integer.toString(contentLength) : null;
        this.setHeader(0, contentLengthString);
    }
}

