/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.comm.RmiConnectorAddress;
import com.sun.jdmk.comm.RmiConnectorServer;
import com.sun.jdmk.comm.RmiNotificationReceiver;
import com.sun.jdmk.internal.ClassLogger;
import java.rmi.Naming;
import java.rmi.RemoteException;

class RmiNotificationForwarder
implements NotificationBackConnector {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.rmi", "com.sun.jdmk.comm.RmiNotificationForwarder");
    private boolean connected = false;
    private RmiConnectorAddress receiverAddress = null;
    private RmiConnectorServer rmiConnectorServer = null;
    private RmiNotificationReceiver rmiNotificationReceiver = null;

    public RmiNotificationForwarder(RmiConnectorAddress receiverAddress, RmiConnectorServer rmiConnectorServer) throws RemoteException, IllegalAccessException {
        this.receiverAddress = receiverAddress;
        this.rmiConnectorServer = rmiConnectorServer;
        String receiverName = new String("rmi://" + receiverAddress.getHost() + ":" + receiverAddress.getPort() + "/" + receiverAddress.getName());
        if (logger.finestOn()) {
            logger.finest("Constructor", "looking for " + receiverName);
        }
        try {
            this.rmiNotificationReceiver = (RmiNotificationReceiver)Naming.lookup(receiverName);
            this.connected = true;
            if (this.rmiNotificationReceiver == null) {
                if (logger.finestOn()) {
                    logger.finest("handleEvent", "receiver is null");
                }
                throw new RemoteException("Can't contact RMI Notification receive server at " + receiverName);
            }
        }
        catch (Exception x) {
            throw new RemoteException("Can't contact RMI Notification receive server at " + receiverName);
        }
    }

    public void disconnect() {
        this.connected = false;
    }

    @Override
    public Object[] remoteRequest(int opType, Object[] params) throws Exception {
        if (this.connected) {
            return this.rmiNotificationReceiver.remoteRequest(opType, params);
        }
        throw new CommunicationException("NotificationForwarder not connected");
    }
}

