/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.application;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.application.StateHolder;
import org.ajax4jsf.context.ContextInitParameters;
import org.ajax4jsf.util.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.core.Conversation;
import org.nuxeo.ecm.platform.ui.web.application.NuxeoViewStateHolder;

public class NuxeoConversationStateHolder
implements Serializable,
StateHolder {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_NUMBER_OF_CONVERSATIONS_IN_SESSION = 4;
    public static final String NUMBER_OF_CONVERSATIONS_IN_SESSION = "nuxeo.jsf.numberOfConversationsInSession";
    protected static final String STATE_HOLDER = NuxeoConversationStateHolder.class.getName();
    protected static final String NO_LONGRUNNING_CONVERSATION_ID = "NOLRC";
    private static final Log _log = LogFactory.getLog(NuxeoConversationStateHolder.class);
    protected final int numbersOfViewsInSession;
    protected final int numbersOfLogicalViews;
    protected final int numbersOfConversationsInSession;
    protected final LRUMap<String, StateHolder> stateHolderByConversation;

    protected static int getNbOfConversationsInSession(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String value = externalContext.getInitParameter(NUMBER_OF_CONVERSATIONS_IN_SESSION);
        if (null == value) {
            return 4;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new FacesException("Context parameter nuxeo.jsf.numberOfConversationsInSession must have integer value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StateHolder newInstance(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(true);
        Map sessionMap = externalContext.getSessionMap();
        StateHolder instance = (StateHolder)sessionMap.get(STATE_HOLDER);
        if (null == instance) {
            Object object = session;
            synchronized (object) {
                instance = (StateHolder)sessionMap.get(STATE_HOLDER);
                if (null == instance) {
                    instance = new NuxeoConversationStateHolder(NuxeoConversationStateHolder.getNbOfConversationsInSession(context), ContextInitParameters.getNumbersOfViewsInSession((FacesContext)context), ContextInitParameters.getNumbersOfLogicalViews((FacesContext)context));
                    sessionMap.put(STATE_HOLDER, instance);
                }
            }
        }
        return instance;
    }

    private NuxeoConversationStateHolder(int numberOfConversationsInSession, int numbersOfViewsInSession, int numbersOfLogicalViews) {
        this.numbersOfViewsInSession = numbersOfViewsInSession;
        this.numbersOfLogicalViews = numbersOfLogicalViews;
        this.numbersOfConversationsInSession = numberOfConversationsInSession;
        this.stateHolderByConversation = new LRUMap(numberOfConversationsInSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getState(FacesContext context, String viewId, String sequence) {
        Object[] state = null;
        LRUMap<String, StateHolder> lRUMap = this.stateHolderByConversation;
        synchronized (lRUMap) {
            for (StateHolder a : this.stateHolderByConversation.values()) {
                state = a.getState(context, viewId, sequence);
                if (state == null) continue;
                return state;
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Could not find state. Maybe there are too many conversations running.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(FacesContext context, String viewId, String sequence, Object[] state) {
        if (state != null) {
            Conversation conversation = Conversation.instance();
            String conversationId = null;
            conversationId = conversation.isLongRunning() ? conversation.getId() : NO_LONGRUNNING_CONVERSATION_ID;
            LRUMap<String, StateHolder> lRUMap = this.stateHolderByConversation;
            synchronized (lRUMap) {
                StateHolder stateHolder = null;
                if (!this.stateHolderByConversation.containsKey((Object)conversationId)) {
                    stateHolder = new NuxeoViewStateHolder(this.numbersOfViewsInSession, this.numbersOfLogicalViews);
                    if (this.stateHolderByConversation.size() == this.numbersOfConversationsInSession && _log.isDebugEnabled()) {
                        _log.debug((Object)("Too many conversations, dumping the least recently used conversation (" + (String)this.stateHolderByConversation.keySet().iterator().next() + ")"));
                    }
                    this.stateHolderByConversation.put((Object)conversationId, (Object)stateHolder);
                } else {
                    stateHolder = (StateHolder)this.stateHolderByConversation.get((Object)conversationId);
                }
                stateHolder.saveState(context, viewId, sequence, state);
            }
            this.updateInstance(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInstance(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(true);
        Map sessionMap = externalContext.getSessionMap();
        Object object = session;
        synchronized (object) {
            sessionMap.put(STATE_HOLDER, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        LRUMap<String, StateHolder> lRUMap = this.stateHolderByConversation;
        synchronized (lRUMap) {
            stream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

