/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.application;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.ajax4jsf.application.StateHolder;
import org.ajax4jsf.util.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NuxeoViewStateHolder
implements Serializable,
StateHolder {
    private static final long serialVersionUID = 1L;
    private static final Log _log = LogFactory.getLog(NuxeoViewStateHolder.class);
    private final LRUMap<String, LRUMap<String, StateReference>> views;
    private final int numberOfViews;

    public NuxeoViewStateHolder(int capacity, int numberOfViews) {
        this.views = new LRUMap(capacity + 1);
        this.numberOfViews = numberOfViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getState(FacesContext context, String viewId, String sequence) {
        if (null == viewId) {
            throw new NullPointerException("viewId parameter for get saved view state is null");
        }
        Object[] state = null;
        LRUMap<String, LRUMap<String, StateReference>> lRUMap = this.views;
        synchronized (lRUMap) {
            LRUMap viewVersions = (LRUMap)this.views.get((Object)viewId);
            if (null != viewVersions) {
                StateReference stateReference;
                if (null != sequence && null != (stateReference = (StateReference)viewVersions.get((Object)sequence))) {
                    state = stateReference.getState();
                }
                if (null == state && _log.isDebugEnabled()) {
                    _log.debug((Object)("No saved view state for sequence " + sequence));
                }
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("No saved view states for viewId " + viewId));
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(FacesContext context, String viewId, String sequence, Object[] state) {
        if (null == viewId) {
            throw new NullPointerException("viewId parameter for  save view state is null");
        }
        if (null == sequence) {
            throw new NullPointerException("sequence parameter for save view state is null");
        }
        if (null != state) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Save new viewState in session for viewId " + viewId + " and sequence " + sequence));
            }
            LRUMap<String, LRUMap<String, StateReference>> lRUMap = this.views;
            synchronized (lRUMap) {
                LRUMap viewVersions = (LRUMap)this.views.get((Object)viewId);
                StateReference stateReference = null;
                if (null == viewVersions) {
                    viewVersions = new LRUMap(this.numberOfViews + 1);
                    this.views.put((Object)viewId, (Object)viewVersions);
                    stateReference = new StateReference(state);
                    viewVersions.put((Object)sequence, (Object)stateReference);
                } else {
                    stateReference = (StateReference)viewVersions.get((Object)sequence);
                    if (null == stateReference) {
                        stateReference = new StateReference(state);
                        viewVersions.put((Object)sequence, (Object)stateReference);
                    } else {
                        stateReference.setState(state);
                    }
                }
            }
        }
    }

    private static class StateReference
    implements Serializable {
        private Object[] state;

        public Object[] getState() {
            return this.state;
        }

        public void setState(Object[] state) {
            this.state = state;
        }

        public StateReference(Object[] state) {
            this.state = state;
        }
    }
}

